<?php
/**
 * French Language File
 * SSCI Office Platform
 */

return [
    // General
    'app_name' => 'Bureau SSCI',
    'company_name' => 'Shepherd Sécurité et Consultance Internationale',
    'welcome' => 'Bienvenue',
    'login' => 'Connexion',
    'logout' => 'Déconnexion',
    'register' => 'S\'inscrire',
    'email' => 'Email',
    'password' => 'Mot de passe',
    'confirm_password' => 'Confirmer le mot de passe',
    'remember_me' => 'Se souvenir de moi',
    'forgot_password' => 'Mot de passe oublié?',
    'sign_in' => 'Se connecter',
    'sign_up' => 'S\'inscrire',
    'reset_password' => 'Réinitialiser le mot de passe',
    'submit' => 'Envoyer',
    'cancel' => 'Annuler',
    'save' => 'Enregistrer',
    'update' => 'Mettre à jour',
    'delete' => 'Supprimer',
    'edit' => 'Modifier',
    'view' => 'Voir',
    'add' => 'Ajouter',
    'user' => 'Utilisateur',
    'english' => 'English',
    'french' => 'Français',
    'close' => 'Fermer',
    'back' => 'Retour',
    'next' => 'Suivant',
    'previous' => 'Précédent',
    'search' => 'Rechercher',
    'filter' => 'Filtrer',
    'export' => 'Exporter',
    'import' => 'Importer',
    'print' => 'Imprimer',
    'download' => 'Télécharger',
    'upload' => 'Télécharger',
    'loading' => 'Chargement...',
    'saving' => 'Enregistrement...',
    'deleting' => 'Suppression...',
    'success' => 'Succès',
    'error' => 'Erreur',
    'warning' => 'Attention',
    'info' => 'Information',
    'confirm' => 'Confirmer',
    'are_you_sure' => 'Êtes-vous sûr?',
    'yes' => 'Oui',
    'no' => 'Non',
    'ok' => 'OK',

    // Navigation
    'dashboard' => 'Tableau de bord',
    'clients' => 'Clients',
    'staff' => 'Personnel',
    'posts' => 'Postes de sécurité',
    'finances' => 'Finances',
    'controls' => 'Contrôles des gardes',
    'guards' => 'Gestion des gardes',
    'messages' => 'Messages',
    'evaluations' => 'Évaluations',
    'settings' => 'Paramètres',
    'patrols' => 'Patrouilles',
    'profile' => 'Profil',
    'account' => 'Compte',
    'notifications' => 'Notifications',
    'help' => 'Aide',
    'about' => 'À propos',
    'contact' => 'Contact',

    // Dashboard
    'dashboard_title' => 'Tableau de bord',
    'total_clients' => 'Clients totaux',
    'total_staff' => 'Personnel total',
    'total_posts' => 'Postes total',
    'total_revenue' => 'Chiffre d\'affaires total',
    'quick_actions' => 'Actions rapides',
    'system_status' => 'État du système',
    'recent_activity' => 'Activité récente',
    'add_client' => 'Ajouter un client',
    'add_staff' => 'Ajouter du personnel',
    'add_post' => 'Ajouter un poste',
    'create_invoice' => 'Créer une facture',
    'add_control' => 'Ajouter un contrôle',
    'send_message' => 'Envoyer un message',
    'database_status' => 'État de la base de données',
    'email_service' => 'Service d\'email',
    'sms_service' => 'Service SMS',
    'push_service' => 'Service de notification Push',
    'online' => 'En ligne',
    'offline' => 'Hors ligne',
    'ok_status' => 'OK',

    // Clients Module
    'clients_title' => 'Gestion des clients',
    'client_list' => 'Liste des clients',
    'add_new_client' => 'Ajouter un nouveau client',
    'edit_client' => 'Modifier le client',
    'delete_client' => 'Supprimer le client',
    'client_name' => 'Nom du client',
    'client_email' => 'Email du client',
    'client_phone' => 'Téléphone du client',
    'client_address' => 'Adresse du client',
    'client_city' => 'Ville',
    'client_country' => 'Pays',
    'client_since' => 'Client depuis',
    'status' => 'Statut',
    'active' => 'Actif',
    'inactive' => 'Inactif',
    'contact_person' => 'Personne de contact',
    'no_clients' => 'Aucun client trouvé',
    'client_created' => 'Client créé avec succès',
    'client_updated' => 'Client mis à jour avec succès',
    'client_deleted' => 'Client supprimé avec succès',

    // Staff Module
    'staff_title' => 'Gestion du personnel',
    'staff_list' => 'Liste du personnel',
    'add_new_staff' => 'Ajouter un nouveau membre du personnel',
    'edit_staff' => 'Modifier le personnel',
    'delete_staff' => 'Supprimer le personnel',
    'staff_name' => 'Nom du personnel',
    'staff_email' => 'Email du personnel',
    'staff_phone' => 'Téléphone du personnel',
    'staff_position' => 'Poste',
    'staff_department' => 'Département',
    'staff_hired_date' => 'Date d\'embauche',
    'role' => 'Rôle',
    'admin' => 'Administrateur',
    'manager' => 'Gestionnaire',
    'controller' => 'Contrôleur',
    'guard' => 'Garde',
    'client_role' => 'Client',
    'no_staff' => 'Aucun personnel trouvé',
    'staff_created' => 'Personnel créé avec succès',
    'staff_updated' => 'Personnel mis à jour avec succès',
    'staff_deleted' => 'Personnel supprimé avec succès',

    // Posts Module
    'posts_title' => 'Postes de sécurité',
    'posts_list' => 'Liste des postes',
    'add_new_post' => 'Ajouter un nouveau poste',
    'edit_post' => 'Modifier le poste',
    'delete_post' => 'Supprimer le poste',
    'post_name' => 'Nom du poste',
    'post_location' => 'Localisation du poste',
    'post_client' => 'Client du poste',
    'post_guards' => 'Nombre de gardes',
    'post_salary' => 'Salaire du poste',
    'post_description' => 'Description du poste',
    'post_status' => 'Statut du poste',
    'no_posts' => 'Aucun poste trouvé',
    'post_created' => 'Poste créé avec succès',
    'post_updated' => 'Poste mis à jour avec succès',
    'post_deleted' => 'Poste supprimé avec succès',

    // Finance Module
    'finances_title' => 'Finances',
    'invoices' => 'Factures',
    'payments' => 'Paiements',
    'salaries' => 'Salaires',
    'invoice_list' => 'Liste des factures',
    'invoice_number' => 'Numéro de facture',
    'invoice_date' => 'Date de la facture',
    'invoice_due_date' => 'Date d\'échéance',
    'invoice_amount' => 'Montant',
    'invoice_status' => 'Statut',
    'draft' => 'Brouillon',
    'sent' => 'Envoyé',
    'paid' => 'Payé',
    'overdue' => 'En retard',
    'payments' => 'Paiements',
    'payment_list' => 'Liste des paiements',
    'payment_date' => 'Date du paiement',
    'payment_amount' => 'Montant du paiement',
    'expenses' => 'Dépenses',
    'expense_list' => 'Liste des dépenses',
    'expense_date' => 'Date de la dépense',
    'expense_amount' => 'Montant de la dépense',
    'no_invoices' => 'Aucune facture trouvée',
    'no_payments' => 'Aucun paiement trouvé',
    'no_expenses' => 'Aucune dépense trouvée',
    'invoice_created' => 'Facture créée avec succès',
    'payment_created' => 'Paiement créé avec succès',
    'expense_created' => 'Dépense créée avec succès',

    // Controls Module
    'controls_title' => 'Contrôles des gardes',
    'controls_list' => 'Liste des contrôles',
    'control_date' => 'Date du contrôle',
    'control_guard' => 'Garde',
    'control_post' => 'Poste',
    'control_score' => 'Score (1-5)',
    'control_notes' => 'Notes',
    'no_controls' => 'Aucun contrôle trouvé',
    'control_created' => 'Contrôle créé avec succès',

    // Messages Module
    'messages_title' => 'Messages',
    'messages_list' => 'Liste des messages',
    'new_message' => 'Nouveau message',
    'message_to' => 'À',
    'message_subject' => 'Sujet',
    'message_body' => 'Message',
    'message_sent' => 'Message envoyé avec succès',
    'message_read' => 'Lu',
    'message_unread' => 'Non lu',
    'no_messages' => 'Aucun message trouvé',
    'compose' => 'Composer',
    'send_message' => 'Envoyer le message',
    'recipient' => 'Destinataire',
    'subject' => 'Sujet',
    'message' => 'Message',
    'attachments' => 'Pièces jointes',
    'inbox' => 'Boîte de réception',
    'sent' => 'Envoyé',

    // Evaluations Module
    'evaluations_title' => 'Évaluations',
    'evaluations_list' => 'Liste des évaluations',
    'add_evaluation' => 'Ajouter une évaluation',
    'evaluation_date' => 'Date de l\'évaluation',
    'evaluation_subject' => 'Sujet de l\'évaluation',
    'evaluation_score' => 'Score',
    'evaluation_notes' => 'Notes',
    'controller_evaluations' => 'Évaluations des contrôleurs',
    'manager_evaluations' => 'Évaluations des gestionnaires',
    'no_evaluations' => 'Aucune évaluation trouvée',

    // Settings Module
    'settings_title' => 'Paramètres',
    'general_settings' => 'Paramètres généraux',
    'notification_settings' => 'Paramètres de notification',
    'email_settings' => 'Paramètres d\'email',
    'sms_settings' => 'Paramètres SMS',
    'push_settings' => 'Paramètres de notification Push',
    'site_name' => 'Nom du site',
    'site_url' => 'URL du site',
    'site_timezone' => 'Fuseau horaire',
    'enable_notifications' => 'Activer les notifications',
    'enable_email' => 'Activer l\'email',
    'enable_sms' => 'Activer le SMS',
    'enable_push' => 'Activer les notifications Push',
    'smtp_host' => 'Hôte SMTP',
    'smtp_port' => 'Port SMTP',
    'smtp_user' => 'Utilisateur SMTP',
    'smtp_password' => 'Mot de passe SMTP',
    'sms_gateway_key' => 'Clé de passerelle SMS',
    'whatsapp_token' => 'Jeton WhatsApp',
    'settings_saved' => 'Paramètres enregistrés avec succès',

    // Patrols Module
    'patrols_title' => 'Patrouilles',
    'patrols_list' => 'Liste des patrouilles',
    'add_patrol' => 'Ajouter une patrouille',
    'patrol_date' => 'Date de la patrouille',
    'patrol_guard' => 'Garde',
    'patrol_post' => 'Poste',
    'patrol_notes' => 'Notes de patrouille',
    'no_patrols' => 'Aucune patrouille trouvée',
    'patrol_created' => 'Patrouille créée avec succès',

    // Errors
    'error_invalid_email' => 'Email invalide',
    'error_password_mismatch' => 'Les mots de passe ne correspondent pas',
    'error_short_password' => 'Le mot de passe doit contenir au moins 6 caractères',
    'error_email_exists' => 'Cet email existe déjà',
    'error_invalid_credentials' => 'Email ou mot de passe invalide',
    'error_unauthorized' => 'Non autorisé',
    'error_not_found' => 'Non trouvé',
    'error_server' => 'Erreur serveur',
    'error_network' => 'Erreur réseau',
    'error_database' => 'Erreur de base de données',
    'error_permission' => 'Permission refusée',
    'error_invalid_input' => 'Veuillez vérifier tous les champs',

    // Form Labels
    'first_name' => 'Prénom',
    'last_name' => 'Nom de famille',
    'full_name' => 'Nom complet',
    'phone' => 'Téléphone',
    'address' => 'Adresse',
    'city' => 'Ville',
    'country' => 'Pays',
    'zip_code' => 'Code postal',
    'description' => 'Description',
    'notes' => 'Notes',
    'created_at' => 'Créé le',
    'updated_at' => 'Mis à jour le',
    'date' => 'Date',
    'time' => 'Heure',
    'amount' => 'Montant',
    'quantity' => 'Quantité',
    'rate' => 'Tarif',
    'total' => 'Total',
    'subtotal' => 'Sous-total',
    'tax' => 'Taxe',
    'discount' => 'Remise',

    // Time
    'today' => 'Aujourd\'hui',
    'yesterday' => 'Hier',
    'tomorrow' => 'Demain',
    'this_week' => 'Cette semaine',
    'last_week' => 'La semaine dernière',
    'this_month' => 'Ce mois',
    'last_month' => 'Le mois dernier',
    'this_year' => 'Cette année',
    'last_year' => 'L\'année dernière',
    'january' => 'Janvier',
    'february' => 'Février',
    'march' => 'Mars',
    'april' => 'Avril',
    'may' => 'Mai',
    'june' => 'Juin',
    'july' => 'Juillet',
    'august' => 'Août',
    'september' => 'Septembre',
    'october' => 'Octobre',
    'november' => 'Novembre',
    'december' => 'Décembre',
    'monday' => 'Lundi',
    'tuesday' => 'Mardi',
    'wednesday' => 'Mercredi',
    'thursday' => 'Jeudi',
    'friday' => 'Vendredi',
    'saturday' => 'Samedi',
    'sunday' => 'Dimanche',

    // Status
    'status_active' => 'Actif',
    'status_inactive' => 'Inactif',
    'status_pending' => 'En attente',
    'status_completed' => 'Complété',
    'status_cancelled' => 'Annulé',
    'status_draft' => 'Brouillon',

    // Pagination
    'showing' => 'Affichage',
    'of' => 'de',
    'entries' => 'entrées',
    'page' => 'Page',

    // Footer
    'all_rights_reserved' => 'Tous droits réservés',
    'powered_by' => 'Propulsé par',
    'version' => 'Version',
    'offline_mode' => 'Mode hors ligne',
    'last_sync' => 'Dernière synchronisation:',
    'reconnecting' => 'Reconnexion...',

    // Auth Messages
    'registration_successful' => 'Inscription réussie! Veuillez vérifier votre email.',
    'redirecting' => 'Redirection...',
    'have_account' => 'Vous avez déjà un compte?',
    'min_8_characters' => 'Minimum 8 caractères',
    'password_reset_success' => 'Mot de passe réinitialisé avec succès',
    'join_us' => 'Rejoignez SSCI Office',
    'fast_setup' => 'Mise en place rapide',
    'get_started_quickly' => 'Commencez en quelques minutes',
    'secure' => 'Sécurisé',
    'enterprise_grade' => 'Sécurité de niveau entreprise',
    'support' => 'Support 24/7',
    'always_here' => 'Toujours là pour vous aider',
    'currency' => 'FCFA',
    
    // System Status
    'database' => 'Base de données',
    'push_notifications' => 'Notifications push',
    'enabled' => 'Activé',
    'disabled' => 'Désactivé',
    'registered' => 'Enregistré',
    'view_all' => 'Afficher tout',
    'mark_all_read' => 'Marquer tout comme lu',
    'system_name' => 'Plateforme de Sécurité SSCI',
    'system_description' => 'Plateforme complète de gestion des entreprises de sécurité avec gestion des clients, suivi du personnel, contrôle financier et évaluations de performance',
    'quick_links' => 'Liens Rapides',
    'information' => 'Information',

    // Assessment Surface Area Categories
    'petite' => 'Petite (<0.5ha)',
    'normale' => 'Normale (0.5-1ha)',
    'vaste' => 'Vaste (1-5ha)',
    'tres_vaste' => 'Très Vaste (>5ha)',

    // Assessment Access Points Categories
    'access_1_2' => '1-2 (Faible)',
    'access_3_4' => '3-4 (Modéré)',
    'access_5' => '5 (Élevé)',
    'access_5_plus' => '5+ (Critique)',

    // Assessment Buildings Categories
    'buildings_1' => '1 Unité (Faible)',
    'buildings_2' => '2 Unités (Modéré)',
    'buildings_3_plus' => '3+ Unités (Élevé)',

    // Assessment Content Value Categories
    'value_low' => '<2M FCFA (Faible)',
    'value_moderate' => '2-10M FCFA (Modéré)',
    'value_high' => '10-50M FCFA (Élevé)',
    'value_very_high' => '>50M FCFA (Très Élevé)',

    // Risk Assessment Calculations
    'infrastructure_risk' => 'Risque d\'Infrastructure',
    'zone_risk' => 'Risque de Zone',
    'asset_risk' => 'Risque d\'Actifs',
    'low_risk' => 'Risque Faible',
    'medium_risk' => 'Risque Modéré',
    'high_risk' => 'Risque Élevé',
    'critical_risk' => 'Risque Critique',

    // Téléchargement de photo de profil
    'profile_photo' => 'Photo de profil',
    'upload_photo' => 'Télécharger la photo',
    'change_photo' => 'Changer la photo',
    'drag_drop_photo' => 'Glissez et déposez votre photo ici',
    'square_crop_recommended' => 'Format carré recommandé',
    'select_file' => 'Sélectionner un fichier',
    'crop_photo' => 'Recadrer la photo',
    'photo_updated' => 'La photo a été mise à jour avec succès',
    'continue' => 'Continuer',
    
    // Settings - Database
    'database_settings' => 'Paramètres de base de données',
    'db_host' => 'Hôte de base de données',
    'db_port' => 'Port de base de données',
    'db_name' => 'Nom de la base de données',
    'db_user' => 'Utilisateur de base de données',
    'db_password' => 'Mot de passe de base de données',
    'leave_blank_to_keep_current' => 'Laissez vide pour conserver le mot de passe actuel',
    
    // Settings - Email/SMTP
    'email_settings' => 'Paramètres d\'email',
    'enable_email' => 'Activer les notifications par email',
    'smtp_host' => 'Hôte SMTP',
    'smtp_port' => 'Port SMTP',
    'smtp_user' => 'Nom d\'utilisateur SMTP',
    'smtp_password' => 'Mot de passe SMTP',
    'smtp_from' => 'Adresse email d\'origine',
    'from_email' => 'Adresse email d\'origine',
    
    // Settings - Application
    'app_settings' => 'Paramètres de l\'application',
    'app_debug' => 'Activer le mode de débogage',
    'enable_debug_mode' => 'Activer le mode de débogage',
    'app_url' => 'URL de l\'application',
    'app_key' => 'Clé de l\'application',
    'app_key_description' => 'Ceci est une clé secrète utilisée pour le chiffrement',
    'generate' => 'Générer',
    'key_generated' => 'Clé générée avec succès',
    
    // Settings - Notifications
    'sms_settings' => 'Paramètres SMS',
    'sms_username' => 'Nom d\'utilisateur SMS',
    'sms_password' => 'Mot de passe SMS',
    'whatsapp_settings' => 'Paramètres WhatsApp',
    'whatsapp_instance_id' => 'Identifiant d\'instance WhatsApp',
    'whatsapp_instance_id_help' => 'Obtenez votre identifiant d\'instance depuis le tableau de bord ultramsg.com',
    'whatsapp_api_token' => 'Token API WhatsApp',
    'enable_whatsapp_notifications' => 'Activer les notifications WhatsApp',
    'push_notifications' => 'Notifications Push',
    'enable_push_notifications' => 'Activer les notifications Push',
    
    // Settings - Messages
    'settings_updated_successfully' => 'Paramètres mis à jour avec succès',
    'profile_updated_successfully' => 'Profil mis à jour avec succès',
    'password_changed_successfully' => 'Mot de passe modifié avec succès',
    'preferences_updated_successfully' => 'Préférences mises à jour avec succès',
    'password_mismatch' => 'Les mots de passe ne correspondent pas',
    'passwords_do_not_match' => 'Les mots de passe ne correspondent pas',
    'updating' => 'Mise à jour...',
    'saving' => 'Enregistrement...',
    
    // Notification Messages
    'welcome_message' => 'Bienvenue sur SSCI Office',
    'account_created' => 'Votre compte a été créé avec succès',
    'account_created_message' => 'Vous pouvez maintenant vous connecter avec vos identifiants',
    'profile_created' => 'Profil créé avec succès',
    'client_created' => 'Client créé avec succès',
    'staff_created' => 'Personnel créé avec succès',
    'post_created' => 'Poste créé avec succès',
    'invoice_created' => 'Facture créée avec succès',
    'payment_recorded' => 'Paiement enregistré avec succès',
    'message_sent' => 'Message envoyé avec succès',
    'control_created' => 'Contrôle créé avec succès',
    'salary_paid' => 'Salaire payé avec succès',
    'feedback_received' => 'Retour reçu avec succès',
    'item_updated' => 'Élément mis à jour avec succès',
    'payment_status_updated' => 'Statut du paiement mis à jour',
    
    // Profile Page
    'manage_profile' => 'Voir et gérer votre profil',
    'profile_information' => 'Informations du profil',
    'change_password' => 'Changer le mot de passe',
    'security' => 'Sécurité',
    'preferences' => 'Préférences',
    'current_password' => 'Mot de passe actuel',
    'new_password' => 'Nouveau mot de passe',
    'update_password' => 'Mettre à jour le mot de passe',
    'password_requirements' => 'Minimum 8 caractères avec majuscules, minuscules, chiffres et symboles',
    'email_cannot_be_changed' => 'L\'adresse email ne peut pas être modifiée',
    'two_factor_authentication' => 'Authentification à deux facteurs',
    '2fa_description' => 'Ajoutez une couche de sécurité supplémentaire à votre compte',
    'enable_2fa' => 'Activer 2FA',
    '2fa_setup_required' => 'Vous aurez besoin d\'une application authenticatrice',
    'save_changes' => 'Enregistrer les modifications',
    'save_preferences' => 'Enregistrer les préférences',
    'notification_preferences' => 'Préférences de notification',
    'receive_email_notifications' => 'Recevoir les notifications par email',
    'receive_in_app_notifications' => 'Recevoir les notifications dans l\'application',
    'receive_sms_notifications' => 'Recevoir les notifications par SMS',

    // Staff/Users Management
    'manage_staff_members' => 'Gérer les membres de l\'équipe et les utilisateurs',
    'add_user' => 'Ajouter un utilisateur',
    'add_first_user' => 'Ajouter le premier utilisateur',
    'search_by_name_or_email' => 'Rechercher par nom ou email',
    'all_roles' => 'Tous les rôles',
    'all_statuses' => 'Tous les statuts',
    'last_login' => 'Dernière connexion',
    'actions' => 'Actions',
    'edit_user' => 'Modifier l\'utilisateur',
    'add_new_user' => 'Ajouter un nouvel utilisateur',
    'reset_password_for' => 'Réinitialiser le mot de passe pour',
    'yes_reset' => 'Oui, réinitialiser le mot de passe',
    'password_reset' => 'Le mot de passe a été réinitialisé',
    'deactivate' => 'Désactiver',
    'activate' => 'Activer',
    'yes_continue' => 'Oui, continuer',
    'delete_user' => 'Supprimer l\'utilisateur',
    'delete_confirm_message' => 'Cette action ne peut pas être annulée. Êtes-vous sûr de vouloir supprimer',
    'yes_delete' => 'Oui, supprimer',
    'no_users_found' => 'Aucun utilisateur trouvé',
    'not_provided' => 'Non fourni',
    'never' => 'Jamais',

    // Roles Management
    'roles' => 'Rôles',
    'manage_user_roles' => 'Gérer les rôles et les permissions',
    'permissions' => 'Permissions',
    'no_permissions' => 'Aucune permission assignée',
    'permission_matrix' => 'Matrice des permissions',
    'permission' => 'Permission',
    'create_new_role' => 'Créer un nouveau rôle',
    'add_custom_role' => 'Ajouter un rôle personnalisé pour votre organisation',
    'role_name' => 'Nom du rôle',
    'role_name_lowercase' => 'Le nom du rôle doit être en minuscules sans espaces',
    'select_permissions' => 'Sélectionner les permissions',
    'create' => 'Créer',
    'delete_role' => 'Supprimer le rôle',
    'delete_role_confirm' => 'Êtes-vous sûr de vouloir supprimer ce rôle? Cela ne peut pas être annulé.',
    'role_deleted' => 'Le rôle a été supprimé avec succès',

    // Settings Page
    'general_settings' => 'Paramètres généraux',
    'appearance_settings' => 'Paramètres d\'apparence',
    'appearance' => 'Apparence',
    'advanced_settings' => 'Paramètres avancés',
    'advanced' => 'Avancé',
    'site_information' => 'Informations du site',
    'email_address' => 'Adresse email',
    'phone_number' => 'Numéro de téléphone',
    'logo' => 'Logo',
    'letterhead' => 'En-tête',
    'upload_logo' => 'Télécharger le logo',
    'upload_letterhead' => 'Télécharger l\'en-tête',
    'color_picker' => 'Choisir une couleur',
    'sms_gateway' => 'Passerelle SMS',
    'sms_gateway_settings' => 'Configuration de la passerelle SMS',
    'sms_token' => 'Token de passerelle SMS',
    'whatsapp_token' => 'Token API WhatsApp',
    'system_information' => 'Informations système',
    'php_version' => 'Version PHP',
    'server' => 'Serveur',
    'current_time' => 'Heure actuelle',
    'backup_database' => 'Sauvegarder la base de données',
    'clear_cache' => 'Effacer le cache',
    'cache_cleared' => 'Cache effacé avec succès',
    'backup_created' => 'Sauvegarde créée avec succès',
    'backup' => 'Sauvegarde et maintenance',
    'backup_in_progress' => 'La sauvegarde de la base de données est en cours de préparation...',
    'confirm_clear_cache' => 'Cela effacera toutes les données en cache',
    'an_error_occurred' => 'Une erreur s\'est produite',
    'name' => 'Nom',
    
    // User Management - Additional Labels
    'user_management' => 'Gestion des utilisateurs',
    'manage_users_and_roles' => 'Gérer les utilisateurs, les rôles et les permissions',
    'manage_users' => 'Gérer les utilisateurs',
    'users' => 'Utilisateurs',
    'no_users' => 'Aucun utilisateur trouvé',
    'error_loading_users' => 'Erreur lors du chargement des utilisateurs',
    'error_loading_user' => 'Erreur lors du chargement des détails de l\'utilisateur',
    'error_saving_user' => 'Erreur lors de l\'enregistrement de l\'utilisateur',
    'error_deleting_user' => 'Erreur lors de la suppression de l\'utilisateur',
    'user_created' => 'Utilisateur créé avec succès',
    'user_updated' => 'Utilisateur mis à jour avec succès',
    'user_deleted' => 'Utilisateur supprimé avec succès',
    'delete_user_confirm' => 'Êtes-vous sûr de vouloir supprimer cet utilisateur?',
    'role' => 'Rôle',
    'phone' => 'Téléphone',
    'whatsapp' => 'WhatsApp',
    'address' => 'Adresse',
    'status' => 'Statut',
    'created_at' => 'Créé',
    'file_too_large' => 'Le fichier est trop volumineux',
    'invalid_file_type' => 'Type de fichier invalide',
    'image_formats' => 'PNG, JPG, GIF jusqu\'à 5 Mo',
    'crop_image' => 'Rogner l\'image',
    'crop_and_save' => 'Rogner et enregistrer',
    'done' => 'Terminé',

    // Client Section
    'my_dashboard' => 'Mon tableau de bord',
    'my_post' => 'Mon poste',
    'my_posts' => 'Mes postes',
    'my_guards' => 'Mes gardes',
    'my_controls' => 'Mes contrôles',
    'my_feedbacks' => 'Retours',
    'my_patrols' => 'Mes patrouilles',
    'my_payments' => 'Mes paiements',
    'my_invoices' => 'Mes Factures',
    'posts_in_zone' => 'Postes en zone',
    'contract' => 'Contrat',
    'site_assessment' => 'Évaluation du Site',

    // Patrol System
    'manage_and_track_guard_patrols' => 'Gérer et suivre les patrouilles des gardes',
    'overview' => 'Aperçu',
    'dashboard' => 'Tableau de bord',
    'patrol_score' => 'Score de Patrouille',
    'patrol_points' => 'Points de Patrouille',
    'scans' => 'Analyses',
    'patrol_settings' => 'Paramètres de Patrouille',
    'reminder_time' => 'Heure de Rappel',
    'minutes_before_hour_end' => 'minutes avant la fin de l\'heure',
    'reminders_sent_at_minute' => 'Les rappels sont envoyés à la minute',
    'of_each_hour' => 'de chaque heure',
    'manage_patrol_for' => 'Gérer la patrouille pour',
    'manage_points' => 'Gérer les Points',
    'patrol_completed' => 'Complété',
    'patrol_incomplete' => 'Incomplet',
    'patrol_missed' => 'Manqué',
    'next_patrol_hour' => 'Prochaine Heure de Patrouille Dans',
    'start_scanner' => 'Démarrer le Lecteur',
    'stop_scanner' => 'Arrêter le Lecteur',
    'scan_qr_code' => 'Numériser le Code QR',
    'last_scan_info' => 'Informations de la Dernière Analyse',
    'recent_scans' => 'Analyses Récentes',
    'patrol_history' => 'Historique des Patrouilles',
    'patrol_time' => 'Heure de Patrouille',
    'completion_percentage' => 'Pourcentage d\'Achèvement',
    'view_details' => 'Voir les Détails',
    'no_posts_available' => 'Aucun poste disponible',
    'manage_patrol_points' => 'Gérer les Points de Patrouille',
    'add_patrol_point' => 'Ajouter un Point de Patrouille',
    'edit_patrol_point' => 'Modifier le Point de Patrouille',
    'delete_patrol_point' => 'Supprimer le Point de Patrouille',
    'point_name' => 'Nom du Point',
    'qr_code' => 'Code QR',
    'point_status' => 'Statut du Point',
    'scan_count' => 'Nombre d\'Analyses',
    'complete' => 'Complète',

    // Feedback
    'feedbacks' => 'Retours',
    'feedback' => 'Retour',
    'add_feedback' => 'Ajouter un Retour',
    'edit_feedback' => 'Modifier le Retour',
    'delete_feedback' => 'Supprimer le Retour',
    'feedback_date' => 'Date du Retour',
    'feedback_subject' => 'Sujet',
    'feedback_message' => 'Message',
    'feedback_rating' => 'Évaluation',
    'feedback_status' => 'Statut',
    'feedback_type' => 'Type de Retour',
    'positive' => 'Positif',
    'negative' => 'Négatif',
    'neutral' => 'Neutre',
    'create_feedback' => 'Créer un Retour',
    'my_feedbacks' => 'Mes Retours',
    'manage_points' => 'Gérer les Points',
    'activate' => 'Activer',
    'deactivate' => 'Désactiver',
    'select_post' => 'Sélectionner un Poste',
    'current_time' => 'Heure Actuelle',
    'this_hour' => 'Cette Heure',
    'today' => "Aujourd'hui",
    'no_scans_yet' => 'Aucune analyse enregistrée',
    'contact_administrator' => 'Contactez votre administrateur pour ajouter des postes à votre compte',
];



