<?php
/**
 * Main Entry Point
 * SSCI Office Platform
 */

// Handle static asset requests with correct MIME types
$requestUri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

// Serve service-worker.js with correct MIME type
if (strpos($requestUri, '/service-worker.js') !== false || ($_GET['asset'] ?? null) === 'worker') {
    header('Content-Type: application/javascript; charset=utf-8');
    header('Service-Worker-Allowed: /');
    header('Cache-Control: public, max-age=3600');
    header('Access-Control-Allow-Origin: *');
    readfile(__DIR__ . '/service-worker.js');
    exit;
}

// Serve manifest.json with correct MIME type
if (strpos($requestUri, '/manifest.json') !== false || ($_GET['asset'] ?? null) === 'manifest') {
    header('Content-Type: application/json; charset=utf-8');
    header('Cache-Control: public, max-age=3600');
    header('Access-Control-Allow-Origin: *');
    readfile(__DIR__ . '/manifest.json');
    exit;
}

require_once __DIR__ . '/../config/bootstrap.php';

use SSCI\Classes\Language;

$auth = $GLOBALS['auth'];
$config = $GLOBALS['config'];

// Determine page to load
$page = $_GET['page'] ?? 'landing';
$action = $_GET['action'] ?? null;

// Handle logout action
if ($action === 'logout') {
    $auth->logout();
    header('Location: index.php?page=landing');
    exit();
}

// Landing page is public, no auth required
if ($page === 'landing') {
    // If authenticated, redirect to dashboard
    if ($auth->isAuthenticated()) {
        header('Location: index.php?page=dashboard');
        exit();
    }
    // Otherwise show landing page (no auth check needed)
} else {
    // Redirect logged-in users from auth pages to dashboard
    if (in_array($page, ['login', 'register', 'forgot-password', 'reset-password']) && $auth->isAuthenticated()) {
        header('Location: index.php?page=dashboard');
        exit();
    }

    // Check if user is authenticated for non-auth pages
    if (!in_array($page, ['login', 'register', 'forgot-password', 'reset-password']) && !$auth->isAuthenticated()) {
        header('Location: index.php?page=login');
        exit();
    }
}

// Route to appropriate page
switch ($page) {
    // Landing Page
    case 'landing':
        require SSCI_VIEWS . '/landing.php';
        break;

    // Auth pages
    case 'login':
        require SSCI_VIEWS . '/auth/login.php';
        break;
    case 'register':
        require SSCI_VIEWS . '/auth/register.php';
        break;
    case 'forgot-password':
        require SSCI_VIEWS . '/auth/forgot-password.php';
        break;
    case 'reset-password':
        require SSCI_VIEWS . '/auth/reset-password.php';
        break;

    // Dashboard
    case 'dashboard':
        // If client user, redirect to client dashboard
        if ($auth->isAuthenticated() && $_SESSION['role'] === 'client') {
            header('Location: index.php?page=clients/dashboard');
            exit();
        }
        // If guard user, redirect to guard dashboard
        if ($auth->isAuthenticated() && $_SESSION['role'] === 'guard') {
            header('Location: index.php?page=guards-dashboard');
            exit();
        }
        // If controller user, redirect to controller dashboard
        if ($auth->isAuthenticated() && $_SESSION['role'] === 'controller') {
            header('Location: index.php?page=controllers-dashboard');
            exit();
        }
        // Admin dashboard
        if ($auth->canAccessPage('dashboard')) {
            require SSCI_VIEWS . '/admin/dashboard.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;

    // Admin pages
    case 'clients':
        if ($auth->canAccessPage('clients')) {
            require SSCI_VIEWS . '/admin/clients/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'staff':
        if ($auth->canAccessPage('staff')) {
            require SSCI_VIEWS . '/admin/staff/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'posts':
        if ($auth->canAccessPage('posts')) {
            require SSCI_VIEWS . '/admin/posts/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'finances':
        if ($auth->canAccessPage('finances')) {
            require SSCI_VIEWS . '/admin/finances/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'invoices':
        if ($auth->canAccessPage('finances')) {
            require SSCI_VIEWS . '/admin/invoices/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'payments':
        if ($auth->canAccessPage('payments')) {
            require SSCI_VIEWS . '/admin/payments/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'salaries':
        if ($auth->canAccessPage('salaries')) {
            require SSCI_VIEWS . '/admin/salaries/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'controls':
        if ($auth->canAccessPage('controls')) {
            require SSCI_VIEWS . '/admin/controls/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'guards':
        if ($auth->canAccessPage('guards')) {
            require SSCI_VIEWS . '/admin/guards/assign-to-posts.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;

    // Client Pages
    case 'clients/dashboard':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/dashboard.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/my-posts':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/my-posts.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/my-guards':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/my-guards.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/my-controls':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/my-controls.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/create-feedback':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/feedbacks.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/my-feedbacks':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/my-feedbacks.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/my-patrols':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/my-patrols.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/payments':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/payments.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/feedbacks':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/feedbacks.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/messages':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/messages-gmail.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients-messages-gmail':
        if ($auth->canAccessPage('clients-messages-gmail')) {
            require SSCI_VIEWS . '/clients/messages-gmail.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/my-invoices':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/my-invoices.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/profile':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/profile.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/contract':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/contract.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'clients/site-assessment':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/clients/site-assessment.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;

    case 'patrols':
        if ($auth->canAccessPage('patrols')) {
            require SSCI_VIEWS . '/admin/patrols/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;

    case 'admin/patrols/manage-points':
        if ($auth->canAccessPage('patrols') && $auth->hasPermission('manage_patrols')) {
            require SSCI_VIEWS . '/admin/patrols/manage-points.php';
        } else {
            header('Location: index.php?page=patrols');
            exit();
        }
        break;

    case 'messages':
        if ($auth->canAccessPage('messages')) {
            require SSCI_VIEWS . '/admin/messages/gmail-style.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'admin/messages/gmail-style':
        if ($auth->canAccessPage('messages')) {
            require SSCI_VIEWS . '/admin/messages/gmail-style.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;

    case 'feedbacks':
    case 'feedbacks/detail':
        if ($auth->canAccessPage('feedbacks')) {
            if ($page === 'feedbacks/detail') {
                require SSCI_VIEWS . '/admin/feedbacks/detail.php';
            } else {
                require SSCI_VIEWS . '/admin/feedbacks/index.php';
            }
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;

    case 'settings':
        if ($auth->canAccessPage('settings')) {
            require SSCI_VIEWS . '/admin/settings/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'evaluations':
        if ($auth->canAccessPage('evaluations')) {
            require SSCI_VIEWS . '/admin/evaluations/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'roles':
        if ($auth->canAccessPage('roles')) {
            require SSCI_VIEWS . '/admin/roles/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;

    case 'profile':
        if ($auth->isAuthenticated()) {
            require SSCI_VIEWS . '/admin/profile.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;

    // Guard Pages
    case 'guards-dashboard':
        if ($auth->canAccessPage('guards-dashboard')) {
            require SSCI_VIEWS . '/guards/dashboard/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'guards-posts':
        if ($auth->canAccessPage('guards-posts')) {
            require SSCI_VIEWS . '/guards/posts/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'guards-patrols':
        if ($auth->canAccessPage('guards-patrols')) {
            require SSCI_VIEWS . '/guards/patrols/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'guards-controls':
        if ($auth->canAccessPage('guards-controls')) {
            require SSCI_VIEWS . '/guards/controls/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'guards-profile':
        if ($auth->canAccessPage('guards-profile')) {
            require SSCI_VIEWS . '/guards/profile/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'guards-payments':
        if ($auth->canAccessPage('guards-payments')) {
            require SSCI_VIEWS . '/guards/payments/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'guards-messages':
        if ($auth->canAccessPage('guards-messages')) {
            require SSCI_VIEWS . '/guards/messages/gmail-style.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'guards-messages-gmail':
        if ($auth->canAccessPage('guards-messages-gmail')) {
            require SSCI_VIEWS . '/guards/messages/gmail-style.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;

    // Controller Pages
    case 'controllers-dashboard':
        if ($auth->canAccessPage('controllers-dashboard')) {
            require SSCI_VIEWS . '/controllers/dashboard/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'controllers-posts':
        if ($auth->canAccessPage('controllers-posts')) {
            require SSCI_VIEWS . '/controllers/posts/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'controllers-patrols':
        if ($auth->canAccessPage('controllers-patrols')) {
            require SSCI_VIEWS . '/controllers/patrols/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'controllers-controls':
        if ($auth->canAccessPage('controllers-controls')) {
            require SSCI_VIEWS . '/controllers/controls/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'controllers-profile':
        if ($auth->canAccessPage('controllers-profile')) {
            require SSCI_VIEWS . '/controllers/profile/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'controllers-payments':
        if ($auth->canAccessPage('controllers-payments')) {
            require SSCI_VIEWS . '/controllers/payments/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;
    case 'controllers-messages':
        if ($auth->canAccessPage('controllers-messages')) {
            require SSCI_VIEWS . '/controllers/messages/index.php';
        } else {
            header('Location: index.php?page=login');
            exit();
        }
        break;

    // API Endpoints
    case 'api':
        $action = $_GET['action'] ?? '';
        header('Content-Type: application/json');
        
        if (!$auth->isAuthenticated()) {
            http_response_code(401);
            echo json_encode(['success' => false, 'message' => 'Unauthorized']);
            exit();
        }
        
        require SSCI_ROOT . '/app/api.php';
        break;

    // Default
    default:
        header('Location: index.php?page=dashboard');
}
