<?php
/**
 * Placeholder page for admin modules
 * Redirects and notifies that module will be implemented
 */

// Bootstrap is already loaded from public/index.php
$auth = $GLOBALS['auth'];
$page = $_GET['page'] ?? 'admin';

$pageTitle = trans($page) . ' - ' . config('app.name');

require_once __DIR__ . '/../layouts/header.php';
?>

<div class="animate__animated animate__fadeIn">
    <div class="max-w-2xl mx-auto">
        <div class="bg-blue-50 border border-blue-200 rounded-lg p-8 text-center">
            <div class="mb-4">
                <i class="fas fa-tools text-4xl text-blue-600"></i>
            </div>
            <h1 class="text-3xl font-bold text-gray-800 mb-4"><?php echo trans('coming_soon') ?? 'Coming Soon'; ?></h1>
            <p class="text-gray-600 mb-6">
                <?php echo ucfirst($page); ?> module is under development and will be available soon.
            </p>
            
            <div class="bg-white rounded-lg p-6 mb-6 text-left">
                <h2 class="font-bold text-gray-800 mb-3">Planned Features:</h2>
                <ul class="space-y-2 text-gray-600">
                    <li><i class="fas fa-check-circle text-green-600 mr-2"></i>Full CRUD operations</li>
                    <li><i class="fas fa-check-circle text-green-600 mr-2"></i>Advanced filtering and search</li>
                    <li><i class="fas fa-check-circle text-green-600 mr-2"></i>Bulk actions</li>
                    <li><i class="fas fa-check-circle text-green-600 mr-2"></i>Export to PDF/Excel</li>
                    <li><i class="fas fa-check-circle text-green-600 mr-2"></i>Real-time updates</li>
                    <li><i class="fas fa-check-circle text-green-600 mr-2"></i>Mobile responsive</li>
                </ul>
            </div>
            
            <a href="?page=dashboard" class="inline-block bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 transition">
                <i class="fas fa-arrow-left"></i> Back to Dashboard
            </a>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>
