<?php
/**
 * Dashboard Page
 * SSCI Office Platform
 */

// Bootstrap is already loaded from public/index.php
$auth = $GLOBALS['auth'];
$db = $GLOBALS['db'];

$user = $auth->getCurrentUser();
$pageTitle = trans('dashboard') . ' - ' . config('app.name');

// Get dashboard stats
$totalClients = $db->fetch("SELECT COUNT(*) as count FROM clients WHERE active = 1")['count'] ?? 0;
$totalPosts = $db->fetch("SELECT COUNT(*) as count FROM posts WHERE status = 'Active'")['count'] ?? 0;
$totalStaff = $db->fetch("SELECT COUNT(*) as count FROM users WHERE role != 'client' AND active = 1")['count'] ?? 0;
$totalRevenue = $db->fetch("SELECT COALESCE(SUM(total_amount), 0) as total FROM invoices WHERE status = 'Paid'")['total'] ?? 0;

require_once __DIR__ . '/../layouts/header.php';
?>

<div class="animate__animated animate__fadeIn">
    <!-- Page Header -->
    <div class="mb-8 flex items-center justify-between">
        <div>
            <h1 class="text-4xl font-bold text-gray-800 mb-2"><?php echo trans('dashboard'); ?></h1>
            <p class="text-gray-600"><?php echo trans('welcome'); ?>, <?php echo e($user['name']); ?></p>
        </div>
        <button id="installAppBtn" class="hidden bg-green-600 text-white px-6 py-2 rounded-lg hover:bg-green-700 transition font-semibold flex items-center justify-center gap-2">
            <i class="fas fa-download"></i>Install App
        </button>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <!-- Total Clients -->
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-blue-500">
            <div class="flex justify-between items-start">
                <div>
                    <p class="text-gray-600 text-sm font-semibold"><?php echo trans('total_clients'); ?></p>
                    <p class="text-3xl font-bold text-gray-800 mt-2"><?php echo $totalClients; ?></p>
                </div>
                <div class="bg-blue-100 p-3 rounded-lg">
                    <i class="fas fa-users text-blue-600 text-2xl"></i>
                </div>
            </div>
            <p class="text-gray-500 text-xs mt-4">
                <i class="fas fa-arrow-up text-green-600"></i>
                <?php echo trans('active'); ?>
            </p>
        </div>

        <!-- Total Posts -->
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-green-500">
            <div class="flex justify-between items-start">
                <div>
                    <p class="text-gray-600 text-sm font-semibold"><?php echo trans('total_posts'); ?></p>
                    <p class="text-3xl font-bold text-gray-800 mt-2"><?php echo $totalPosts; ?></p>
                </div>
                <div class="bg-green-100 p-3 rounded-lg">
                    <i class="fas fa-map-pin text-green-600 text-2xl"></i>
                </div>
            </div>
            <p class="text-gray-500 text-xs mt-4">
                <span class="text-green-600"><?php echo trans('active'); ?></span>
            </p>
        </div>

        <!-- Total Staff -->
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-yellow-500">
            <div class="flex justify-between items-start">
                <div>
                    <p class="text-gray-600 text-sm font-semibold"><?php echo trans('total_staff'); ?></p>
                    <p class="text-3xl font-bold text-gray-800 mt-2"><?php echo $totalStaff; ?></p>
                </div>
                <div class="bg-yellow-100 p-3 rounded-lg">
                    <i class="fas fa-people-group text-yellow-600 text-2xl"></i>
                </div>
            </div>
            <p class="text-gray-500 text-xs mt-4">
                <span><?php echo trans('registered'); ?></span>
            </p>
        </div>

        <!-- Total Revenue -->
        <div class="bg-white rounded-lg shadow p-6 border-l-4 border-purple-500">
            <div class="flex justify-between items-start">
                <div>
                    <p class="text-gray-600 text-sm font-semibold"><?php echo trans('total_revenue'); ?></p>
                    <p class="text-3xl font-bold text-gray-800 mt-2"><?php echo number_format($totalRevenue, 0); ?> <?php echo trans('currency'); ?></p>
                </div>
                <div class="bg-purple-100 p-3 rounded-lg">
                    <i class="fas fa-money-bill text-purple-600 text-2xl"></i>
                </div>
            </div>
            <p class="text-gray-500 text-xs mt-4">
                <span class="text-green-600"><?php echo trans('this_month'); ?></span>
            </p>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6 mb-8">
        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow p-6">
                <h2 class="text-xl font-bold text-gray-800 mb-4"><?php echo trans('quick_actions'); ?></h2>
                <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                    <a href="?page=clients&action=create" class="flex flex-col items-center justify-center p-4 bg-blue-50 rounded-lg hover:bg-blue-100 transition">
                        <i class="fas fa-user-plus text-blue-600 text-2xl mb-2"></i>
                        <span class="text-sm text-center"><?php echo trans('add_client'); ?></span>
                    </a>
                    <a href="?page=staff&action=create" class="flex flex-col items-center justify-center p-4 bg-green-50 rounded-lg hover:bg-green-100 transition">
                        <i class="fas fa-people-group text-green-600 text-2xl mb-2"></i>
                        <span class="text-sm text-center"><?php echo trans('add_staff'); ?></span>
                    </a>
                    <a href="?page=posts&action=create" class="flex flex-col items-center justify-center p-4 bg-purple-50 rounded-lg hover:bg-purple-100 transition">
                        <i class="fas fa-map-pin text-purple-600 text-2xl mb-2"></i>
                        <span class="text-sm text-center"><?php echo trans('add_post'); ?></span>
                    </a>
                    <a href="?page=finances&action=invoice" class="flex flex-col items-center justify-center p-4 bg-yellow-50 rounded-lg hover:bg-yellow-100 transition">
                        <i class="fas fa-file-invoice text-yellow-600 text-2xl mb-2"></i>
                        <span class="text-sm text-center"><?php echo trans('add_invoice'); ?></span>
                    </a>
                    <a href="?page=controls&action=create" class="flex flex-col items-center justify-center p-4 bg-red-50 rounded-lg hover:bg-red-100 transition">
                        <i class="fas fa-list-check text-red-600 text-2xl mb-2"></i>
                        <span class="text-sm text-center"><?php echo trans('add_control'); ?></span>
                    </a>
                    <a href="?page=messages&action=create" class="flex flex-col items-center justify-center p-4 bg-pink-50 rounded-lg hover:bg-pink-100 transition">
                        <i class="fas fa-envelope text-pink-600 text-2xl mb-2"></i>
                        <span class="text-sm text-center"><?php echo trans('new_message'); ?></span>
                    </a>
                </div>
            </div>
        </div>

        <!-- System Status -->
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-xl font-bold text-gray-800 mb-4"><?php echo trans('system_status'); ?></h2>
            <div class="space-y-3">
                <div class="flex justify-between items-center">
                    <span class="text-gray-600"><?php echo trans('database'); ?></span>
                    <span class="px-3 py-1 bg-green-100 text-green-700 rounded-full text-xs font-semibold"><?php echo trans('online'); ?></span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-gray-600"><?php echo trans('email_service'); ?></span>
                    <span class="px-3 py-1 <?php echo $config['notifications']['email_enabled'] ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-700'; ?> rounded-full text-xs font-semibold">
                        <?php echo $config['notifications']['email_enabled'] ? trans('enabled') : trans('disabled'); ?>
                    </span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-gray-600"><?php echo trans('sms_service'); ?></span>
                    <span class="px-3 py-1 <?php echo $config['notifications']['sms_enabled'] ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-700'; ?> rounded-full text-xs font-semibold">
                        <?php echo $config['notifications']['sms_enabled'] ? trans('enabled') : trans('disabled'); ?>
                    </span>
                </div>
                <div class="flex justify-between items-center">
                    <span class="text-gray-600"><?php echo trans('push_notifications'); ?></span>
                    <span class="px-3 py-1 <?php echo $config['notifications']['push_enabled'] ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-700'; ?> rounded-full text-xs font-semibold">
                        <?php echo $config['notifications']['push_enabled'] ? trans('enabled') : trans('disabled'); ?>
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activity -->
    <!-- Desktop Table View -->
    <div class="hidden md:block bg-white rounded-lg shadow overflow-hidden">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-xl font-bold text-gray-800"><?php echo trans('recent_activity'); ?></h2>
                <a href="?page=reports" class="text-blue-600 hover:text-blue-800 text-sm font-semibold"><?php echo trans('view_all'); ?></a>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full">
                <thead>
                    <tr class="border-b-2 border-gray-200">
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider"><?php echo trans('action'); ?></th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider"><?php echo trans('user'); ?></th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider"><?php echo trans('timestamp'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-3 py-1 bg-blue-100 text-blue-700 rounded-full text-xs font-semibold"><?php echo trans('login'); ?></span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600"><?php echo $user['name']; ?></td>
                        <td class="px-6 py-4 text-sm text-gray-600"><?php echo date('Y-m-d H:i:s'); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Mobile Card View -->
    <div class="md:hidden bg-white rounded-lg shadow overflow-hidden">
        <div class="p-4">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-lg font-bold text-gray-800"><?php echo trans('recent_activity'); ?></h2>
                <a href="?page=reports" class="text-blue-600 hover:text-blue-800 text-xs font-semibold"><?php echo trans('view_all'); ?></a>
            </div>
            <div class="space-y-3">
                <div class="flex items-center justify-between bg-blue-50 p-3 rounded-lg">
                    <div>
                        <div class="text-sm font-semibold text-gray-900"><?php echo trans('login'); ?></div>
                        <div class="text-xs text-gray-500 mt-1"><?php echo $user['name']; ?></div>
                    </div>
                    <div class="text-xs text-gray-500 text-right"><?php echo date('M d, H:i'); ?></div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>
