<?php
/**
 * Admin - Feedback Detail View
 * View detailed feedback information with all criteria scores and remarks
 */

$auth = $GLOBALS['auth'];
$db = $GLOBALS['db'];

// Check permission
if (!$auth->canAccessPage('feedbacks')) {
    header('Location: ?page=admin/dashboard');
    exit();
}

$feedId = $_GET['id'] ?? null;
if (!$feedId) {
    header('Location: ?page=admin/feedbacks');
    exit();
}

// Get feedback with client info
$feedback = $db->fetch(
    "SELECT f.*, u.name as client_name, u.email as client_email
     FROM feedback f
     LEFT JOIN users u ON f.Client = u.id
     WHERE f.FeedID = ?",
    [$feedId]
);

if (!$feedback) {
    header('Location: ?page=admin/feedbacks');
    exit();
}

// Guard criteria
$guardCriteria = [
    'Punctuality' => 'Guard Punctuality',
    'Attendance' => 'Guard Attendance',
    'Neatness' => 'Guard Neatness/Appearance',
    'Patrolling' => 'Guard Patrolling',
    'Communication' => 'Guard Communication',
    'Respect' => 'Guard Respect/Courtesy',
    'Job_Mastery' => 'Guard Job Mastery',
    'Vigilance' => 'Guard Vigilance'
];

// Controller criteria
$controllerCriteria = [
    'Frequency' => 'Controller Frequency',
    'Response' => 'Controller Response Time',
    'Collaboration' => 'Controller Collaboration'
];

// Management criteria
$managementCriteria = [
    'Service_Delivery' => 'Service Delivery',
    'Timeliness' => 'Timeliness',
    'Innovation' => 'Innovation',
    'Documentation' => 'Documentation'
];

require_once __DIR__ . '/../../layouts/header.php';
?>

<div class="container mx-auto px-4 py-8 max-w-4xl">
    <!-- Header with Back Button -->
    <div class="mb-8 flex items-center justify-between">
        <div>
            <h1 class="text-4xl font-bold text-gray-800">
                <i class="fas fa-star text-yellow-600 mr-3"></i>Feedback Detail
            </h1>
            <p class="text-gray-600 mt-2"><?php echo htmlspecialchars($feedback['client_name']); ?> - <?php echo date('M d, Y', strtotime($feedback['Date'])); ?></p>
        </div>
        <a href="?page=admin/feedbacks" class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 font-semibold transition flex items-center gap-2">
            <i class="fas fa-arrow-left"></i>Back
        </a>
    </div>

    <!-- Client Information -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <!-- Subject & Date -->
        <div class="bg-white rounded-lg shadow border border-gray-200 p-6">
            <h3 class="text-sm font-semibold text-gray-700 mb-2">Subject</h3>
            <p class="text-lg font-bold text-gray-800"><?php echo htmlspecialchars($feedback['Subject'] ?? 'No Subject'); ?></p>
            <h3 class="text-sm font-semibold text-gray-700 mt-4 mb-2">Date</h3>
            <p class="text-lg text-gray-700"><?php echo date('F d, Y', strtotime($feedback['Date'])); ?></p>
        </div>

        <!-- Client Info -->
        <div class="bg-white rounded-lg shadow border border-gray-200 p-6">
            <h3 class="text-sm font-semibold text-gray-700 mb-2">Client</h3>
            <p class="text-lg font-bold text-gray-800"><?php echo htmlspecialchars($feedback['client_name'] ?? 'Unknown'); ?></p>
            <h3 class="text-sm font-semibold text-gray-700 mt-4 mb-2">Email</h3>
            <p class="text-sm text-blue-600 break-all"><?php echo htmlspecialchars($feedback['client_email'] ?? '-'); ?></p>
        </div>

        <!-- Overall Score -->
        <div class="bg-gradient-to-br from-amber-50 to-amber-100 rounded-lg shadow border border-amber-200 p-6 text-center">
            <h3 class="text-sm font-semibold text-gray-700 mb-2">Overall Score</h3>
            <p class="text-5xl font-bold text-amber-600"><?php echo $feedback['Overall_Score']; ?></p>
            <p class="text-sm text-gray-600 mt-2">Out of 5.00</p>
            <div class="flex justify-center gap-1 mt-3 text-amber-500">
                <?php for ($i = 0; $i < round($feedback['Overall_Score']); $i++): ?>
                    <i class="fas fa-star"></i>
                <?php endfor; ?>
            </div>
        </div>
    </div>

    <!-- Score Summary -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <!-- Guard Score -->
        <div class="bg-green-50 rounded-lg border border-green-200 p-6">
            <h3 class="text-lg font-bold text-green-800 mb-4">
                <i class="fas fa-user-shield mr-2"></i>Guard Score
            </h3>
            <p class="text-4xl font-bold text-green-600"><?php echo $feedback['Guard_Score']; ?>/5.00</p>
            <div class="mt-4 space-y-2">
                <?php foreach ($guardCriteria as $key => $label): ?>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-700"><?php echo htmlspecialchars(str_replace('_', ' ', $label)); ?></span>
                        <span class="font-semibold text-green-700"><?php echo $feedback[$key] ?? 0; ?>/5</span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Controller Score -->
        <div class="bg-purple-50 rounded-lg border border-purple-200 p-6">
            <h3 class="text-lg font-bold text-purple-800 mb-4">
                <i class="fas fa-tasks mr-2"></i>Controller Score
            </h3>
            <p class="text-4xl font-bold text-purple-600"><?php echo $feedback['Controller_Score']; ?>/5.00</p>
            <div class="mt-4 space-y-2">
                <?php foreach ($controllerCriteria as $key => $label): ?>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-700"><?php echo htmlspecialchars($label); ?></span>
                        <span class="font-semibold text-purple-700"><?php echo $feedback[$key] ?? 0; ?>/5</span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- Management Score -->
        <div class="bg-red-50 rounded-lg border border-red-200 p-6">
            <h3 class="text-lg font-bold text-red-800 mb-4">
                <i class="fas fa-chart-line mr-2"></i>Management Score
            </h3>
            <p class="text-4xl font-bold text-red-600"><?php echo $feedback['Management_Score']; ?>/5.00</p>
            <div class="mt-4 space-y-2">
                <?php foreach ($managementCriteria as $key => $label): ?>
                    <div class="flex items-center justify-between text-sm">
                        <span class="text-gray-700"><?php echo htmlspecialchars($label); ?></span>
                        <span class="font-semibold text-red-700"><?php echo $feedback[$key] ?? 0; ?>/5</span>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <!-- Additional Criteria -->
    <div class="bg-white rounded-lg shadow border border-gray-200 p-6 mb-8">
        <h3 class="text-lg font-bold text-gray-800 mb-4">
            <i class="fas fa-plus-circle mr-2"></i>Additional Criteria
        </h3>
        <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
            <span class="text-gray-700 font-semibold">Equipping/Resources</span>
            <span class="text-2xl font-bold text-blue-600"><?php echo $feedback['Equipping'] ?? 0; ?>/5</span>
        </div>
    </div>

    <!-- Remarks Section -->
    <?php if (!empty($feedback['Remarks'])): ?>
        <div class="bg-white rounded-lg shadow border border-gray-200 p-6">
            <h3 class="text-lg font-bold text-gray-800 mb-4">
                <i class="fas fa-note-sticky mr-2"></i>Remarks & Comments
            </h3>
            <div class="bg-gray-50 p-4 rounded-lg text-gray-700 whitespace-pre-wrap">
                <?php echo htmlspecialchars($feedback['Remarks']); ?>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../../layouts/footer.php'; ?>
