<?php
/**
 * Login Page
 * SSCI Office Platform
 */

require_once __DIR__ . '/../../config/bootstrap.php';

$auth = $GLOBALS['auth'];

// Redirect if already logged in
if ($auth->isAuthenticated()) {
    header('Location: index.php?page=dashboard');
    exit();
}

// Handle language switching
if (isset($_GET['lang']) && in_array($_GET['lang'], ['en', 'fr'])) {
    load_language($_GET['lang']);
    header('Location: ?page=login');
    exit();
}

// Handle login form submission
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    if ($auth->login($email, $password)) {
        header('Location: index.php?page=dashboard');
        exit();
    } else {
        $error = trans('error_invalid_credentials');
    }
}

$pageTitle = trans('login') . ' - ' . config('app.name');

require_once __DIR__ . '/header.php';
?>

<div class="bg-white rounded-lg shadow-xl p-8 animate__animated animate__fadeInUp">
    <div class="text-center mb-8">
        <img src="<?php echo config('app.ui.site_logo'); ?>" alt="Logo" class="h-16 mx-auto mb-4">
        <h1 class="text-3xl font-bold text-gray-800"><?php echo config('app.acronym'); ?></h1>
        <p class="text-gray-600 mt-2"><?php echo config('app.company'); ?></p>
    </div>

    <?php if ($error): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
            <i class="fas fa-exclamation-circle"></i> <?php echo e($error); ?>
        </div>
    <?php endif; ?>

    <form method="POST" action="">
        <div class="mb-4">
            <label for="email" class="block text-gray-700 font-bold mb-2"><?php echo trans('email'); ?></label>
            <input type="email" id="email" name="email" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500" placeholder="<?php echo trans('email'); ?>">
        </div>

        <div class="mb-6">
            <label for="password" class="block text-gray-700 font-bold mb-2"><?php echo trans('password'); ?></label>
            <input type="password" id="password" name="password" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500" placeholder="<?php echo trans('password'); ?>">
        </div>

        <div class="flex items-center justify-between mb-6">
            <label class="flex items-center text-gray-700">
                <input type="checkbox" name="remember" class="mr-2">
                <?php echo trans('remember_me'); ?>
            </label>
            <a href="?page=forgot-password" class="text-blue-600 hover:text-blue-800"><?php echo trans('forgot_password'); ?></a>
        </div>

        <button type="submit" class="w-full bg-blue-600 text-white font-bold py-2 px-4 rounded-lg hover:bg-blue-700 transition">
            <i class="fas fa-sign-in-alt"></i> <?php echo trans('sign_in'); ?>
        </button>
    </form>

    <div class="mt-6 text-center">
        <p class="text-gray-600"><?php echo trans('welcome'); ?> 
            <a href="?page=register" class="text-blue-600 font-bold hover:text-blue-800"><?php echo trans('register'); ?></a>
        </p>
    </div>
</div>

<?php require_once __DIR__ . '/footer.php'; ?>
