<?php
/**
 * Client - My Controls (Readonly)
 * View all controls recorded for client's posts
 */

$auth = $GLOBALS['auth'];
$db = $GLOBALS['db'];

// Get current user
$user = $db->fetch("SELECT id, name FROM users WHERE id = ? AND role = 'client'", [$_SESSION['user_id'] ?? 0]);
if (!$user) {
    header('Location: ?page=dashboard');
    exit();
}

// Get controls for user's posts
$controls = $db->fetchAll(
    "SELECT gc.*, p.name as post_name, u.name as guard_name, cu.name as controller_name,
            ROUND((gc.attendance_punctuality + gc.uniform_presentation + gc.patrol_reporting_discipline + gc.client_feedback + gc.controller_general_evaluation) / 5 * 20, 0) as overall_percent
     FROM guards_controls gc
     JOIN posts p ON gc.post_id = p.id
     JOIN users u ON gc.guard_id = u.id
     LEFT JOIN users cu ON gc.controller_id = cu.id
     WHERE p.owner_id = ?
     ORDER BY gc.control_datetime DESC",
    [$_SESSION['user_id']]
);

require_once __DIR__ . '/../layouts/header.php';
?>

<div class="container mx-auto px-4 py-8 max-w-7xl">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <h1 class="text-4xl font-bold text-gray-800">
                <i class="fas fa-check-circle text-blue-600 mr-3"></i>My Controls
            </h1>
            <a href="?page=clients/dashboard" class="px-6 py-3 bg-gray-600 text-white rounded-lg hover:bg-gray-700 font-semibold">
                <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
            </a>
        </div>
        <p class="text-gray-600 mt-2">
            Total controls recorded: <span class="font-bold text-blue-600"><?php echo count($controls); ?></span>
        </p>
    </div>

    <!-- Controls Table -->
    <?php if (!empty($controls)): ?>
        <div class="bg-white rounded-lg shadow border border-gray-200 overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-100 border-b border-gray-200">
                        <tr>
                            <th class="px-6 py-3 text-left font-semibold text-gray-700">Date & Time</th>
                            <th class="px-6 py-3 text-left font-semibold text-gray-700">Post</th>
                            <th class="px-6 py-3 text-left font-semibold text-gray-700">Guard</th>
                            <th class="px-6 py-3 text-center font-semibold text-gray-700">Attendance</th>
                            <th class="px-6 py-3 text-center font-semibold text-gray-700">Uniform</th>
                            <th class="px-6 py-3 text-center font-semibold text-gray-700">Patrol</th>
                            <th class="px-6 py-3 text-center font-semibold text-gray-700">Client</th>
                            <th class="px-6 py-3 text-center font-semibold text-gray-700">General</th>
                            <th class="px-6 py-3 text-center font-semibold text-gray-700">Overall</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        <?php foreach ($controls as $control): 
                            $avgScore = ($control['attendance_punctuality'] + $control['uniform_presentation'] + $control['patrol_reporting_discipline'] + $control['client_feedback'] + $control['controller_general_evaluation']) / 5;
                            $scorePercent = round(($avgScore / 5) * 100);
                        ?>
                            <tr class="hover:bg-gray-50 transition">
                                <td class="px-6 py-4 text-sm"><?php echo date('M d, Y H:i', strtotime($control['control_datetime'])); ?></td>
                                <td class="px-6 py-4 font-semibold"><?php echo htmlspecialchars($control['post_name']); ?></td>
                                <td class="px-6 py-4 text-sm"><?php echo htmlspecialchars($control['guard_name']); ?></td>
                                <td class="px-6 py-4 text-center">
                                    <span class="inline-block px-2 py-1 rounded text-xs font-semibold <?php 
                                        echo $control['attendance_punctuality'] >= 4 ? 'bg-green-100 text-green-700' : ($control['attendance_punctuality'] >= 3 ? 'bg-yellow-100 text-yellow-700' : 'bg-red-100 text-red-700');
                                    ?>">
                                        <?php echo $control['attendance_punctuality']; ?>/5
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <span class="inline-block px-2 py-1 rounded text-xs font-semibold <?php 
                                        echo $control['uniform_presentation'] >= 4 ? 'bg-green-100 text-green-700' : ($control['uniform_presentation'] >= 3 ? 'bg-yellow-100 text-yellow-700' : 'bg-red-100 text-red-700');
                                    ?>">
                                        <?php echo $control['uniform_presentation']; ?>/5
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <span class="inline-block px-2 py-1 rounded text-xs font-semibold <?php 
                                        echo $control['patrol_reporting_discipline'] >= 4 ? 'bg-green-100 text-green-700' : ($control['patrol_reporting_discipline'] >= 3 ? 'bg-yellow-100 text-yellow-700' : 'bg-red-100 text-red-700');
                                    ?>">
                                        <?php echo $control['patrol_reporting_discipline']; ?>/5
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <span class="inline-block px-2 py-1 rounded text-xs font-semibold <?php 
                                        echo $control['client_feedback'] >= 4 ? 'bg-green-100 text-green-700' : ($control['client_feedback'] >= 3 ? 'bg-yellow-100 text-yellow-700' : 'bg-red-100 text-red-700');
                                    ?>">
                                        <?php echo $control['client_feedback']; ?>/5
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <span class="inline-block px-2 py-1 rounded text-xs font-semibold <?php 
                                        echo $control['controller_general_evaluation'] >= 4 ? 'bg-green-100 text-green-700' : ($control['controller_general_evaluation'] >= 3 ? 'bg-yellow-100 text-yellow-700' : 'bg-red-100 text-red-700');
                                    ?>">
                                        <?php echo $control['controller_general_evaluation']; ?>/5
                                    </span>
                                </td>
                                <td class="px-6 py-4 text-center">
                                    <span class="inline-block px-3 py-1 rounded-full text-sm font-bold <?php 
                                        echo $scorePercent >= 80 ? 'bg-green-100 text-green-700' : ($scorePercent >= 60 ? 'bg-yellow-100 text-yellow-700' : 'bg-red-100 text-red-700');
                                    ?>">
                                        <?php echo $scorePercent; ?>%
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php else: ?>
        <div class="bg-white rounded-lg shadow border border-gray-200 p-12 text-center">
            <i class="fas fa-inbox text-5xl text-gray-300 mb-4"></i>
            <p class="text-gray-500 text-lg">No controls recorded yet</p>
            <p class="text-gray-400 text-sm mt-2">Controls will appear here once recorded</p>
        </div>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>
