<?php
/**
 * Client - My Guards (Readonly)
 * View all guards assigned to client's posts
 */

$auth = $GLOBALS['auth'];
$db = $GLOBALS['db'];

// Get current user
$user = $db->fetch("SELECT id, name FROM users WHERE id = ? AND role = 'client'", [$_SESSION['user_id'] ?? 0]);
if (!$user) {
    header('Location: ?page=dashboard');
    exit();
}

// Get guards assigned to user's posts
$guards = $db->fetchAll(
    "SELECT DISTINCT u.id, u.name, u.phone, u.email,
            s.staff_id, s.zone,
            COUNT(DISTINCT gpa.post_id) as post_count,
            COUNT(DISTINCT gc.id) as control_count,
            ROUND(AVG((gc.attendance_punctuality + gc.uniform_presentation + gc.patrol_reporting_discipline + gc.client_feedback + gc.controller_general_evaluation) / 5), 1) as avg_score
     FROM users u
     JOIN guard_post_assignments gpa ON u.id = gpa.guard_id
     JOIN posts p ON gpa.post_id = p.id
     LEFT JOIN staff s ON u.id = s.user_id
     LEFT JOIN guards_controls gc ON u.id = gc.guard_id AND p.id = gc.post_id
     WHERE p.owner_id = ? AND u.role = 'guard'
     GROUP BY u.id
     ORDER BY u.name",
    [$_SESSION['user_id']]
);

require_once __DIR__ . '/../layouts/header.php';
?>

<div class="container mx-auto px-4 py-8 max-w-7xl">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <h1 class="text-4xl font-bold text-gray-800">
                <i class="fas fa-user-shield text-green-600 mr-3"></i>My Guards
            </h1>
            <a href="?page=clients/dashboard" class="px-6 py-3 bg-gray-600 text-white rounded-lg hover:bg-gray-700 font-semibold">
                <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
            </a>
        </div>
        <p class="text-gray-600 mt-2">
            Total guards assigned: <span class="font-bold text-green-600"><?php echo count($guards); ?></span>
        </p>
    </div>

    <!-- Guards Grid - Card Style -->
    <?php if (!empty($guards)): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php foreach ($guards as $guard): ?>
                <div class="bg-white rounded-lg shadow border border-gray-200 hover:shadow-lg transition overflow-hidden">
                    <!-- Guard Header -->
                    <div class="bg-gradient-to-r from-green-600 to-green-700 p-4 text-white">
                        <h3 class="text-lg font-bold"><?php echo htmlspecialchars($guard['name']); ?></h3>
                        <p class="text-green-100 text-sm">
                            Staff ID: <?php echo htmlspecialchars($guard['staff_id'] ?? 'N/A'); ?>
                        </p>
                    </div>

                    <!-- Guard Details -->
                    <div class="p-6 space-y-4">
                        <!-- Contact Info -->
                        <div>
                            <p class="text-xs text-gray-600 font-semibold mb-1">Phone</p>
                            <p class="text-sm text-gray-700"><?php echo htmlspecialchars($guard['phone'] ?? 'N/A'); ?></p>
                        </div>

                        <div>
                            <p class="text-xs text-gray-600 font-semibold mb-1">Zone</p>
                            <p class="text-sm text-gray-700"><?php echo htmlspecialchars($guard['zone'] ?? 'N/A'); ?></p>
                        </div>

                        <!-- Metrics -->
                        <div class="grid grid-cols-3 gap-3 py-3 border-y border-gray-200">
                            <div class="text-center">
                                <p class="text-2xl font-bold text-blue-600"><?php echo $guard['post_count']; ?></p>
                                <p class="text-xs text-gray-600">Posts</p>
                            </div>
                            <div class="text-center">
                                <p class="text-2xl font-bold text-green-600"><?php echo $guard['control_count']; ?></p>
                                <p class="text-xs text-gray-600">Controls</p>
                            </div>
                            <div class="text-center">
                                <p class="text-2xl font-bold text-yellow-600"><?php echo $guard['avg_score'] ? number_format($guard['avg_score'] * 20, 0) . '%' : '-'; ?></p>
                                <p class="text-xs text-gray-600">Avg Score</p>
                            </div>
                        </div>

                        <!-- Performance Badge -->
                        <?php if ($guard['avg_score']): 
                            $scorePercent = $guard['avg_score'] * 20;
                        ?>
                            <div class="w-full bg-gray-200 rounded-full h-2 overflow-hidden">
                                <div class="h-full transition-all <?php 
                                    echo $scorePercent >= 80 ? 'bg-green-500' : ($scorePercent >= 60 ? 'bg-yellow-500' : 'bg-red-500');
                                ?>" style="width: <?php echo $scorePercent; ?>%"></div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Actions -->
                    <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
                        <a href="?page=clients/my-feedbacks" class="w-full block px-3 py-2 bg-green-600 text-white rounded text-sm hover:bg-green-700 font-semibold transition text-center">
                            <i class="fas fa-list mr-1"></i>View Feedbacks
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="bg-white rounded-lg shadow border border-gray-200 p-12 text-center">
            <i class="fas fa-inbox text-5xl text-gray-300 mb-4"></i>
            <p class="text-gray-500 text-lg">No guards assigned yet</p>
            <p class="text-gray-400 text-sm mt-2">Guards assigned to your posts will appear here</p>
        </div>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../layouts/footer.php'; ?>
