<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Employment Contract - <?= htmlspecialchars($staff['staff_id'] ?? '') ?></title>

<!-- Google fonts -->
<link href="https://fonts.googleapis.com/css2?family=PT+Sans+Narrow:wght@400;700&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

<style>
    :root {
        --primary-color: #2563eb;
        --accent-color: #1f2937;
        --text-color: #374151;
        --success-color: #10b981;
        --warning-color: #f59e0b;
        --error-color: #ef4444;
        --muted: #6b7280;
        --border-light: #e5e7eb;
        --page-width: 850px;
    }

    * { margin: 0; padding: 0; box-sizing: border-box; }
    html, body { 
        font-family: 'Roboto', 'PT Sans Narrow', Arial, sans-serif; 
        color: var(--text-color); 
        background: #f9fafb;
        -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
    }

    .page { 
        width: var(--page-width); 
        margin: 32px auto; 
        padding: 48px 40px; 
        background: #ffffff; 
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        page-break-after: always;
    }

    /* Header */
    .contract-header {
        display: flex;
        align-items: flex-start;
        justify-content: space-between;
        border-bottom: 3px solid var(--primary-color);
        padding-bottom: 20px;
        margin-bottom: 30px;
    }

    .company-info {
        display: flex;
        gap: 16px;
        align-items: flex-start;
        flex: 1;
    }

    .company-logo {
        width: 80px;
        height: 80px;
        border-radius: 8px;
        background: var(--accent-color);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: 700;
        font-size: 28px;
        flex-shrink: 0;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .company-details h1 {
        font-size: 18px;
        font-weight: 700;
        margin-bottom: 4px;
        color: var(--primary-color);
    }

    .company-details p {
        font-size: 12px;
        color: var(--muted);
        margin: 2px 0;
        line-height: 1.4;
    }

    .document-meta {
        text-align: right;
        font-size: 12px;
        color: var(--muted);
    }

    .document-meta div {
        margin: 6px 0;
    }

    .document-meta strong {
        color: var(--primary-color);
        font-weight: 600;
    }

    /* Title */
    .contract-title {
        text-align: center;
        margin: 28px 0 8px 0;
        font-size: 22px;
        font-weight: 700;
        color: var(--primary-color);
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .contract-subtitle {
        text-align: center;
        font-size: 13px;
        color: var(--muted);
        margin-bottom: 28px;
        line-height: 1.6;
    }

    /* Content */
    .contract-content {
        font-size: 13px;
        line-height: 1.6;
    }

    .section {
        margin-bottom: 24px;
    }

    .section-title {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 14px;
        font-weight: 700;
        color: white;
        background: var(--primary-color);
        padding: 10px 14px;
        margin-bottom: 12px;
        border-radius: 4px;
    }

    .section-content {
        padding: 0 2px;
    }

    .clause {
        margin: 8px 0;
    }

    .clause p {
        margin: 4px 0;
        text-indent: 18px;
    }

    .clause ol, .clause ul {
        margin: 6px 0 6px 30px !important;
        padding-left: 20px !important;
    }

    .clause ol li, .clause ul li {
        margin: 6px 0;
        line-height: 1.5;
        list-style: disc;
    }

    .clause ol li {
        list-style-type: decimal;
    }

    /* Data display */
    .data-grid {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 16px 24px;
        margin: 8px 0;
        padding: 12px;
        background: #f9fafb;
        border-radius: 4px;
        border-left: 3px solid var(--primary-color);
    }

    .data-item {
        display: flex;
        flex-direction: column;
    }

    .data-label {
        font-size: 11px;
        text-transform: uppercase;
        letter-spacing: 0.3px;
        color: var(--muted);
        font-weight: 600;
        margin-bottom: 3px;
    }

    .data-value {
        font-size: 13px;
        font-weight: 500;
        color: var(--text-color);
        word-break: break-word;
    }

    .data-value.amount {
        font-weight: 600;
        color: var(--success-color);
        font-size: 14px;
    }

    /* Tables */
    .salary-table {
        width: 100%;
        border-collapse: collapse;
        margin: 12px 0;
        font-size: 13px;
    }

    .salary-table th {
        background: var(--primary-color);
        color: white;
        padding: 10px 12px;
        text-align: left;
        font-weight: 600;
        border: none;
    }

    .salary-table td {
        padding: 10px 12px;
        border-bottom: 1px solid var(--border-light);
    }

    .salary-table tbody tr:hover {
        background: #f9fafb;
    }

    .salary-table .amount {
        text-align: right;
        font-weight: 600;
        color: var(--text-color);
    }

    .total-row {
        background: #f0f9ff;
        font-weight: 700;
    }

    .total-row .amount {
        color: var(--primary-color);
        font-weight: 700;
    }

    /* Signature blocks */
    .signatures {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 40px;
        margin-top: 40px;
        padding-top: 20px;
        border-top: 1px solid var(--border-light);
    }

    .signature-block {
        text-align: center;
    }

    .signature-space {
        height: 60px;
        border-bottom: 1px solid var(--border-light);
        margin-bottom: 8px;
    }

    .signature-label {
        font-weight: 600;
        font-size: 12px;
        color: var(--text-color);
        margin-bottom: 4px;
    }

    .signature-title {
        font-size: 11px;
        color: var(--muted);
    }

    /* Footer */
    .contract-footer {
        margin-top: 32px;
        padding-top: 16px;
        border-top: 1px dashed var(--border-light);
        font-size: 11px;
        color: var(--muted);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .footer-info {
        flex: 1;
    }

    .page-marker {
        font-size: 11px;
        color: var(--muted);
    }

    /* Print styles */
    @media print {
        body { 
            background: white;
            padding: 0;
            margin: 0;
        }
        .page { 
            box-shadow: none; 
            margin: 0; 
            padding: 48px 40px;
            page-break-after: always;
        }
        .no-print {
            display: none !important;
        }
    }

    /* Utilities */
    .text-muted { color: var(--muted); }
    .text-success { color: var(--success-color); }
    .text-primary { color: var(--primary-color); }
    .font-bold { font-weight: 700; }
    .text-center { text-align: center; }
</style>
</head>
<body>

<div class="page">
    <!-- Header -->
    <div class="contract-header">
        <div class="company-info">
            <div class="company-logo">SSCI</div>
            <div class="company-details">
                <h1><?= htmlspecialchars($company_name ?? 'SHEPHERD SECURITY AND CONSULTANCY INTERNATIONAL') ?></h1>
                <p><?= htmlspecialchars($company_address ?? 'Opposite PCSS Buea Town, P.O.Box 554, Buea') ?></p>
                <p>📧 <?= htmlspecialchars($company_email ?? 'info@ssci.cm') ?></p>
                <p>📱 <?= htmlspecialchars($company_phone ?? 'Tel: (237) 676037526') ?></p>
            </div>
        </div>
        <div class="document-meta">
            <div>Contract No: <strong><?= htmlspecialchars($staff['staff_id'] ?? 'N/A') ?></strong></div>
            <div>Date Issued: <strong><?= htmlspecialchars($contract_date ?? date('Y-m-d')) ?></strong></div>
            <div>Valid from: <strong><?= htmlspecialchars($staff['contract_date'] ?? date('Y-m-d')) ?></strong></div>
        </div>
    </div>

    <!-- Title -->
    <div class="contract-title">Employment Contract</div>
    <div class="contract-subtitle">
        This contract is made between <span class="font-bold"><?= htmlspecialchars($company_name ?? 'SHEPHERD SECURITY AND CONSULTANCY INTERNATIONAL') ?></span> 
        (the "Employer") and <span class="font-bold"><?= htmlspecialchars($staff['user_id'] ?? 'The Employee') ?></span> (the "Employee").
    </div>

    <!-- Content -->
    <div class="contract-content">

        <!-- 1. Employee Information -->
        <div class="section">
            <div class="section-title">
                <span>👤</span> 1. EMPLOYEE INFORMATION
            </div>
            <div class="section-content">
                <div class="data-grid">
                    <div class="data-item">
                        <div class="data-label">Employee Name</div>
                        <div class="data-value"><?= htmlspecialchars($staff['employee_name'] ?? 'N/A') ?></div>
                    </div>
                    <div class="data-item">
                        <div class="data-label">Staff ID</div>
                        <div class="data-value"><?= htmlspecialchars($staff['staff_id'] ?? 'N/A') ?></div>
                    </div>
                    <div class="data-item">
                        <div class="data-label">Position</div>
                        <div class="data-value"><?= htmlspecialchars($staff['position'] ?? 'N/A') ?></div>
                    </div>
                    <div class="data-item">
                        <div class="data-label">Assigned Zone</div>
                        <div class="data-value"><?= htmlspecialchars($staff['zone'] ?? 'N/A') ?></div>
                    </div>
                    <div class="data-item">
                        <div class="data-label">National ID Number</div>
                        <div class="data-value"><?= htmlspecialchars($staff['national_id'] ?? 'N/A') ?></div>
                    </div>
                    <div class="data-item">
                        <div class="data-label">Email</div>
                        <div class="data-value"><?= htmlspecialchars($staff['email'] ?? 'N/A') ?></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- 2. Employment Terms -->
        <div class="section">
            <div class="section-title">
                <span>📋</span> 2. EMPLOYMENT TERMS
            </div>
            <div class="section-content">
                <div class="clause">
                    <p>The Employee shall be engaged as a <strong><?= htmlspecialchars($staff['position'] ?? 'Staff Member') ?></strong> 
                    assigned to the <strong><?= htmlspecialchars($staff['zone'] ?? 'Company') ?></strong> zone/branch.</p>
                </div>
                <div class="data-grid">
                    <div class="data-item">
                        <div class="data-label">Contract Start Date</div>
                        <div class="data-value"><?= htmlspecialchars($staff['contract_date'] ?? date('Y-m-d')) ?></div>
                    </div>
                    <div class="data-item">
                        <div class="data-label">Contract End Date</div>
                        <div class="data-value"><?= htmlspecialchars($staff['contract_end'] ?? 'Indefinite') ?></div>
                    </div>
                    <div class="data-item">
                        <div class="data-label">Employment Status</div>
                        <div class="data-value" style="text-transform: capitalize;"><?= htmlspecialchars($staff['status'] ?? 'Active') ?></div>
                    </div>
                    <div class="data-item">
                        <div class="data-label">Work Schedule</div>
                        <div class="data-value">24-Hour Security Operations</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- 3. Compensation & Benefits -->
        <div class="section">
            <div class="section-title">
                <span>💰</span> 3. COMPENSATION & BENEFITS
            </div>
            <div class="section-content">
                <div class="clause">
                    <p>The Employee shall receive the following monthly compensation:</p>
                </div>
                <table class="salary-table">
                    <thead>
                        <tr>
                            <th>Component</th>
                            <th class="amount">Amount (FCFA)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $total_monthly = 0;
                        if (!empty($staff['remunerations']) && is_array($staff['remunerations'])) {
                            foreach ($staff['remunerations'] as $remuneration) {
                                $amount = isset($remuneration['amount']) ? floatval($remuneration['amount']) : 0;
                                $total_monthly += $amount;
                                echo '<tr>';
                                echo '<td>' . htmlspecialchars($remuneration['type'] ?? 'Allowance') . '</td>';
                                echo '<td class="amount">' . number_format($amount, 2, ',', ' ') . '</td>';
                                echo '</tr>';
                            }
                        } else {
                            echo '<tr><td colspan="2">To be determined by management</td></tr>';
                        }
                        ?>
                        <tr class="total-row">
                            <td><strong>Total Monthly Compensation</strong></td>
                            <td class="amount"><strong><?= number_format($total_monthly > 0 ? $total_monthly : ($staff['total_monthly_pay'] ?? 0), 2, ',', ' ') ?></strong></td>
                        </tr>
                    </tbody>
                </table>
                <div class="clause">
                    <p>Payment shall be made monthly within 5 working days after month-end.</p>
                </div>
            </div>
        </div>

        <!-- 4. Work Schedule & Shifts -->
        <div class="section">
            <div class="section-title">
                <span>⏰</span> 4. WORK SCHEDULE & SHIFTS
            </div>
            <div class="section-content">
                <table class="salary-table">
                    <thead>
                        <tr>
                            <th>Shift Type</th>
                            <th>Start Time</th>
                            <th>End Time</th>
                            <th>Duration</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><strong>Day Shift</strong></td>
                            <td>06:00 AM</td>
                            <td>06:00 PM</td>
                            <td>12 hours</td>
                        </tr>
                        <tr>
                            <td><strong>Night Shift</strong></td>
                            <td>06:00 PM</td>
                            <td>06:00 AM</td>
                            <td>12 hours</td>
                        </tr>
                    </tbody>
                </table>
                <div class="clause">
                    <p>The Employee is required to work assigned shifts without objection. Shift assignments shall be determined by management based on operational requirements.</p>
                </div>
            </div>
        </div>

        <!-- 5. Employee Responsibilities -->
        <div class="section">
            <div class="section-title">
                <span>✅</span> 5. EMPLOYEE RESPONSIBILITIES
            </div>
            <div class="section-content">
                <div class="clause">
                    <p>The Employee shall adhere to the following responsibilities:</p>
                    <ol>
                        <li>Report to work punctually and remain until the end of assigned shift</li>
                        <li>Maintain professional appearance and wear uniform at all times while on duty</li>
                        <li>Keep working environment and materials clean and properly organized</li>
                        <li>Return all company properties and equipment immediately after duty</li>
                        <li>Perform assigned duties conscientiously, professionally, and efficiently</li>
                        <li>Exhibit discipline, respect for hierarchy, and professional conduct</li>
                        <li>Maintain courteous and professional attitude towards clients and visitors</li>
                        <li>Observe strict confidentiality of company business and client information</li>
                        <li>Complete accurate entries in logbooks and duty records</li>
                        <li>Report immediately any incidents, damages, or security concerns</li>
                        <li>Cooperate fully with management and fellow employees</li>
                        <li>Comply with all company policies and standard operating procedures</li>
                    </ol>
                </div>
            </div>
        </div>

        <!-- 6. Prohibited Conduct -->
        <div class="section">
            <div class="section-title">
                <span>⛔</span> 6. PROHIBITED CONDUCT
            </div>
            <div class="section-content">
                <div class="clause">
                    <p>The Employee is strictly prohibited from:</p>
                    <ol>
                        <li>Reporting to work under the influence of alcohol or illegal substances</li>
                        <li>Sleeping, reading, or engaging in unauthorized activities during working hours</li>
                        <li>Introducing alcoholic beverages or unauthorized persons into the workplace</li>
                        <li>Using company equipment, materials, or property for personal purposes</li>
                        <li>Engaging in illegal activities whether on or off duty</li>
                        <li>Participating in or encouraging actions that disrupt normal operations</li>
                        <li>Abandoning assigned post without proper handover to authorized personnel</li>
                        <li>Engaging in disputes or arguments with clients, visitors, or colleagues</li>
                        <li>Acting on behalf of the company without express authorization</li>
                        <li>Disclosing confidential company information to unauthorized parties</li>
                        <li>Harassment or discrimination of any kind</li>
                        <li>Negligence in duty that endangers company assets or personnel</li>
                    </ol>
                </div>
            </div>
        </div>

        <!-- 7. Disciplinary Procedures -->
        <div class="section">
            <div class="section-title">
                <span>⚖️</span> 7. DISCIPLINARY PROCEDURES
            </div>
            <div class="section-content">
                <div class="clause">
                    <p>Violation of contract terms may result in disciplinary action following this procedure:</p>
                    <ol>
                        <li><strong>Verbal Warning:</strong> First minor violation or infraction</li>
                        <li><strong>Written Warning:</strong> Repeated violations or serious misconduct</li>
                        <li><strong>Suspension:</strong> Continued violations after written warning</li>
                        <li><strong>Termination:</strong> Serious misconduct or repeated violations</li>
                    </ol>
                    <p>Serious violations (theft, violence, gross insubordination) may result in immediate termination without notice.</p>
                </div>
            </div>
        </div>

        <!-- 8. Contract Termination -->
        <div class="section">
            <div class="section-title">
                <span>🔚</span> 8. CONTRACT TERMINATION
            </div>
            <div class="section-content">
                <div class="clause">
                    <p><strong>By Employer:</strong> The Employer may terminate this contract with 14 days written notice or payment in lieu of notice.</p>
                    <p><strong>By Employee:</strong> The Employee may terminate this contract with 14 days written notice to management.</p>
                    <p><strong>Without Cause:</strong> Either party may terminate for any reason with proper notice.</p>
                    <p><strong>For Cause:</strong> Immediate termination for gross misconduct, theft, or safety violations.</p>
                </div>
            </div>
        </div>

        <!-- 9. Acceptance of Terms -->
        <div class="section">
            <div class="section-title">
                <span>📝</span> 9. ACCEPTANCE & ACKNOWLEDGMENT
            </div>
            <div class="section-content">
                <div class="clause">
                    <p>I, <strong><?= htmlspecialchars($staff['user_id'] ?? 'The Employee') ?></strong>, hereby acknowledge that:</p>
                    <ol>
                        <li>I have read and fully understand all terms and conditions of this contract</li>
                        <li>I agree to abide by all company policies and procedures</li>
                        <li>I accept the position, compensation, and responsibilities outlined above</li>
                        <li>I understand the disciplinary procedures and consequences of violations</li>
                        <li>I am prepared to commence employment under these terms</li>
                    </ol>
                </div>
            </div>
        </div>

        <!-- 10. Signatures -->
        <div class="section">
            <div class="section-title">
                <span>✍️</span> 10. AUTHORIZED SIGNATURES
            </div>
            <div class="signatures">
                <div class="signature-block">
                    <div class="signature-space"></div>
                    <div class="signature-label">Employer Signature</div>
                    <div class="signature-title">SHEPHERD SECURITY AND CONSULTANCY INTERNATIONAL</div>
                    <div class="text-muted" style="font-size: 11px; margin-top: 8px;">Authorized Representative</div>
                </div>
                <div class="signature-block">
                    <div class="signature-space"></div>
                    <div class="signature-label">Employee Signature</div>
                    <div class="signature-title"><?= htmlspecialchars($staff['user_id'] ?? 'Employee') ?></div>
                    <div class="text-muted" style="font-size: 11px; margin-top: 8px;">Staff ID: <?= htmlspecialchars($staff['staff_id'] ?? 'N/A') ?></div>
                </div>
            </div>
        </div>

    </div>

    <!-- Footer -->
    <div class="contract-footer">
        <div class="footer-info">
            <strong><?= htmlspecialchars($company_name ?? 'SSCI') ?></strong> • 
            <?= htmlspecialchars($company_phone ?? 'Tel: (237) 676037526') ?> • 
            <?= htmlspecialchars($company_email ?? 'info@ssci.cm') ?>
        </div>
        <div class="page-marker">Document Generated: <?= date('Y-m-d H:i') ?></div>
    </div>

</div>

</body>
</html>
