<?php
/**
 * Controllers - Dashboard
 * Main dashboard for controllers managing posts in their zone
 */

$auth = $GLOBALS['auth'];
$db = $GLOBALS['db'];

// Get current user
$user = $db->fetch("SELECT id, name FROM users WHERE id = ? AND role = 'controller'", [$_SESSION['user_id'] ?? 0]);
if (!$user) {
    header('Location: ?page=dashboard');
    exit();
}

// Get controller's zone information
$zone = $db->fetch("SELECT * FROM zones WHERE assigned_to = ?", [$_SESSION['user_id']]);

// Get posts in this controller's zone
$postsInZone = $db->fetchAll(
    "SELECT p.* FROM posts p WHERE p.zone_id = ?",
    [$zone ? $zone['id'] : 0]
);

// Get patrols at posts in this zone (this month)
$patrolsThisMonth = $db->fetchAll(
    "SELECT COUNT(*) as count FROM patrols p
     JOIN posts po ON p.post_id = po.id
     WHERE po.zone_id = ? AND MONTH(p.created_at) = MONTH(NOW()) AND YEAR(p.created_at) = YEAR(NOW())",
    [$zone ? $zone['id'] : 0]
);

$patrolCount = $patrolsThisMonth[0]['count'] ?? 0;

// Get controls added this month by this controller
$controlsThisMonth = $db->fetchAll(
    "SELECT COUNT(*) as count FROM controls c
     WHERE c.conducted_by = ? AND MONTH(c.created_at) = MONTH(NOW()) AND YEAR(c.created_at) = YEAR(NOW())",
    [$_SESSION['user_id']]
);

$controlCount = $controlsThisMonth[0]['count'] ?? 0;

// Get unread messages
$unreadMessages = $db->fetch(
    "SELECT COUNT(*) as count FROM messages WHERE recipient_id = ? AND is_read = 0",
    [$_SESSION['user_id']]
);

require_once __DIR__ . '/../../layouts/header.php';
?>

<div class="container mx-auto px-4 py-8 max-w-7xl">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-blue-600 to-blue-700 rounded-lg p-8 text-white shadow-lg">
            <h1 class="text-4xl font-bold">
                <i class="fas fa-tachometer-alt mr-3"></i>Dashboard
            </h1>
            <p class="text-blue-100 mt-2">Welcome back, <?php echo htmlspecialchars($user['name']); ?></p>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-8">
        <!-- Posts in Zone -->
        <div class="bg-white rounded-xl shadow-lg border border-gray-200 p-8 hover:shadow-xl transition">
            <div class="flex items-start justify-between mb-4">
                <div>
                    <p class="text-sm font-bold text-gray-600 uppercase tracking-wide">Posts in Zone</p>
                    <p class="text-4xl font-bold text-blue-600 mt-2"><?php echo count($postsInZone); ?></p>
                </div>
                <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center">
                    <i class="fas fa-map-pin text-2xl text-blue-600"></i>
                </div>
            </div>
            <a href="?page=controllers-posts" class="text-blue-600 hover:text-blue-700 font-semibold text-sm flex items-center gap-1">
                View All <i class="fas fa-arrow-right"></i>
            </a>
        </div>

        <!-- Patrols This Month -->
        <div class="bg-white rounded-xl shadow-lg border border-gray-200 p-8 hover:shadow-xl transition">
            <div class="flex items-start justify-between mb-4">
                <div>
                    <p class="text-sm font-bold text-gray-600 uppercase tracking-wide">Patrols This Month</p>
                    <p class="text-4xl font-bold text-green-600 mt-2"><?php echo $patrolCount; ?></p>
                </div>
                <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center">
                    <i class="fas fa-shoe-prints text-2xl text-green-600"></i>
                </div>
            </div>
            <a href="?page=controllers-patrols" class="text-green-600 hover:text-green-700 font-semibold text-sm flex items-center gap-1">
                View Patrols <i class="fas fa-arrow-right"></i>
            </a>
        </div>

        <!-- Controls This Month -->
        <div class="bg-white rounded-xl shadow-lg border border-gray-200 p-8 hover:shadow-xl transition">
            <div class="flex items-start justify-between mb-4">
                <div>
                    <p class="text-sm font-bold text-gray-600 uppercase tracking-wide">Controls This Month</p>
                    <p class="text-4xl font-bold text-purple-600 mt-2"><?php echo $controlCount; ?></p>
                </div>
                <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center">
                    <i class="fas fa-clipboard-check text-2xl text-purple-600"></i>
                </div>
            </div>
            <a href="?page=controllers-controls" class="text-purple-600 hover:text-purple-700 font-semibold text-sm flex items-center gap-1">
                View Controls <i class="fas fa-arrow-right"></i>
            </a>
        </div>

        <!-- Unread Messages -->
        <div class="bg-white rounded-xl shadow-lg border border-gray-200 p-8 hover:shadow-xl transition">
            <div class="flex items-start justify-between mb-4">
                <div>
                    <p class="text-sm font-bold text-gray-600 uppercase tracking-wide">Unread Messages</p>
                    <p class="text-4xl font-bold text-orange-600 mt-2"><?php echo $unreadMessages['count'] ?? 0; ?></p>
                </div>
                <div class="w-16 h-16 bg-orange-100 rounded-full flex items-center justify-center">
                    <i class="fas fa-envelope text-2xl text-orange-600"></i>
                </div>
            </div>
            <a href="?page=controllers-messages" class="text-orange-600 hover:text-orange-700 font-semibold text-sm flex items-center gap-1">
                View Messages <i class="fas fa-arrow-right"></i>
            </a>
        </div>
    </div>

    <!-- Quick Action Cards -->
    <div class="mb-8">
        <h2 class="text-2xl font-bold text-gray-900 mb-6">
            <i class="fas fa-lightning-bolt text-blue-600 mr-2"></i>Quick Actions
        </h2>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <!-- My Posts -->
            <a href="?page=controllers-posts" class="bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl border-2 border-blue-300 p-8 hover:shadow-lg transition cursor-pointer group">
                <div class="flex items-center gap-4">
                    <div class="w-16 h-16 bg-blue-600 rounded-full flex items-center justify-center group-hover:scale-110 transition">
                        <i class="fas fa-map-pin text-2xl text-white"></i>
                    </div>
                    <div>
                        <h3 class="text-xl font-bold text-gray-900">Posts in My Zone</h3>
                        <p class="text-sm text-gray-600 mt-1">View all posts under your supervision</p>
                    </div>
                </div>
            </a>

            <!-- My Profile -->
            <a href="?page=controllers-profile" class="bg-gradient-to-br from-purple-50 to-purple-100 rounded-xl border-2 border-purple-300 p-8 hover:shadow-lg transition cursor-pointer group">
                <div class="flex items-center gap-4">
                    <div class="w-16 h-16 bg-purple-600 rounded-full flex items-center justify-center group-hover:scale-110 transition">
                        <i class="fas fa-user-circle text-2xl text-white"></i>
                    </div>
                    <div>
                        <h3 class="text-xl font-bold text-gray-900">My Profile</h3>
                        <p class="text-sm text-gray-600 mt-1">View profile and download contract</p>
                    </div>
                </div>
            </a>

            <!-- My Payments -->
            <a href="?page=controllers-payments" class="bg-gradient-to-br from-orange-50 to-orange-100 rounded-xl border-2 border-orange-300 p-8 hover:shadow-lg transition cursor-pointer group">
                <div class="flex items-center gap-4">
                    <div class="w-16 h-16 bg-orange-600 rounded-full flex items-center justify-center group-hover:scale-110 transition">
                        <i class="fas fa-money-bill text-2xl text-white"></i>
                    </div>
                    <div>
                        <h3 class="text-xl font-bold text-gray-900">My Salary</h3>
                        <p class="text-sm text-gray-600 mt-1">View payments and salary info</p>
                    </div>
                </div>
            </a>
        </div>
    </div>

    <!-- Zone Information Card -->
    <?php if ($zone): ?>
        <div class="bg-white rounded-xl shadow-lg border border-gray-200 p-8">
            <h2 class="text-2xl font-bold text-gray-900 mb-6">
                <i class="fas fa-map text-blue-600 mr-2"></i>Zone Information
            </h2>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <!-- Zone Name -->
                <div>
                    <p class="text-sm font-bold text-gray-600 uppercase tracking-wide mb-2">Zone Name</p>
                    <p class="text-2xl font-bold text-gray-900"><?php echo htmlspecialchars($zone['name']); ?></p>
                </div>

                <!-- Zone Description -->
                <div>
                    <p class="text-sm font-bold text-gray-600 uppercase tracking-wide mb-2">Description</p>
                    <p class="text-gray-800"><?php echo htmlspecialchars($zone['description'] ?? 'No description'); ?></p>
                </div>

                <!-- Posts Count -->
                <div>
                    <p class="text-sm font-bold text-gray-600 uppercase tracking-wide mb-2">Posts in Zone</p>
                    <p class="text-2xl font-bold text-blue-600"><?php echo count($postsInZone); ?></p>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../../layouts/footer.php'; ?>
