<?php
/**
 * Controllers - My Profile/Contract
 * View personal profile and download contract
 */

$db = $GLOBALS['db'];

// Verify controller access
$user = $db->fetch("SELECT * FROM users WHERE id = ? AND role = 'controller'", [$_SESSION['user_id'] ?? 0]);
if (!$user) {
    header('Location: ?page=dashboard');
    exit();
}

// Get staff/contract information
$staff = $db->fetch("SELECT * FROM staff WHERE user_id = ?", [$_SESSION['user_id']]);

// Get zone information
$zone = $db->fetch("SELECT * FROM zones WHERE assigned_to = ?", [$_SESSION['user_id']]);

require_once __DIR__ . '/../../layouts/header.php';
?>

<div class="container mx-auto px-4 py-8 max-w-5xl">
    <!-- Header -->
    <div class="mb-8">
        <div class="bg-gradient-to-r from-blue-600 to-blue-700 rounded-lg p-8 text-white shadow-lg">
            <div class="flex items-center gap-6">
                <div class="w-24 h-24 bg-white rounded-full flex items-center justify-center flex-shrink-0">
                    <i class="fas fa-user text-4xl text-blue-600"></i>
                </div>
                <div>
                    <h1 class="text-4xl font-bold"><?php echo htmlspecialchars($user['name']); ?></h1>
                    <p class="text-blue-100 mt-2 text-lg">
                        <i class="fas fa-shield-alt mr-2"></i>Security Controller
                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Two Column Layout -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Left Column - Profile Info -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Personal Information Card -->
            <div class="bg-white rounded-xl shadow-lg border border-gray-200 overflow-hidden">
                <div class="bg-gradient-to-r from-blue-50 to-blue-100 border-b border-gray-200 px-6 py-4">
                    <h2 class="text-2xl font-bold text-gray-900">
                        <i class="fas fa-user-circle text-blue-600 mr-3"></i>Personal Information
                    </h2>
                </div>
                
                <div class="p-8 space-y-5">
                    <div class="grid grid-cols-2 gap-6">
                        <!-- Email -->
                        <div>
                            <label class="text-xs font-bold text-gray-600 uppercase tracking-wide block mb-2">Email Address</label>
                            <p class="text-gray-800 font-semibold text-lg break-all"><?php echo htmlspecialchars($user['email']); ?></p>
                        </div>

                        <!-- Phone -->
                        <div>
                            <label class="text-xs font-bold text-gray-600 uppercase tracking-wide block mb-2">Phone Number</label>
                            <p class="text-gray-800 font-semibold text-lg"><?php echo htmlspecialchars($user['phone'] ?? 'Not provided'); ?></p>
                        </div>

                        <!-- Role -->
                        <div>
                            <label class="text-xs font-bold text-gray-600 uppercase tracking-wide block mb-2">Role</label>
                            <span class="inline-block px-4 py-2 bg-blue-100 text-blue-900 rounded-full font-bold">
                                <i class="fas fa-badge mr-2"></i>Controller
                            </span>
                        </div>

                        <!-- Account Status -->
                        <div>
                            <label class="text-xs font-bold text-gray-600 uppercase tracking-wide block mb-2">Account Status</label>
                            <span class="inline-block px-4 py-2 <?php echo $user['active'] ? 'bg-blue-100 text-blue-900' : 'bg-red-100 text-red-900'; ?> rounded-full font-bold">
                                <i class="fas <?php echo $user['active'] ? 'fa-check-circle' : 'fa-times-circle'; ?> mr-2"></i>
                                <?php echo $user['active'] ? 'Active' : 'Inactive'; ?>
                            </span>
                        </div>
                    </div>

                    <!-- Address (if available from staff table) -->
                    <?php if ($staff && !empty($staff['address'])): ?>
                        <div class="border-t border-gray-200 pt-6">
                            <label class="text-xs font-bold text-gray-600 uppercase tracking-wide block mb-2">Residential Address</label>
                            <p class="text-gray-800 font-semibold leading-relaxed"><?php echo htmlspecialchars($staff['address']); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Zone Assignment Card -->
            <?php if ($zone): ?>
                <div class="bg-white rounded-xl shadow-lg border border-gray-200 overflow-hidden">
                    <div class="bg-gradient-to-r from-purple-50 to-purple-100 border-b border-gray-200 px-6 py-4">
                        <h2 class="text-2xl font-bold text-gray-900">
                            <i class="fas fa-map text-purple-600 mr-3"></i>Zone Assignment
                        </h2>
                    </div>
                    
                    <div class="p-8 space-y-5">
                        <!-- Zone Name -->
                        <div>
                            <label class="text-xs font-bold text-gray-600 uppercase tracking-wide block mb-2">Assigned Zone</label>
                            <p class="text-2xl font-bold text-gray-800"><?php echo htmlspecialchars($zone['name']); ?></p>
                        </div>

                        <!-- Zone Details -->
                        <?php if (!empty($zone['description'])): ?>
                            <div>
                                <label class="text-xs font-bold text-gray-600 uppercase tracking-wide block mb-2">Zone Description</label>
                                <p class="text-gray-800"><?php echo htmlspecialchars($zone['description']); ?></p>
                            </div>
                        <?php endif; ?>

                        <!-- Zone Status -->
                        <div class="bg-purple-50 border border-purple-200 rounded-lg p-4">
                            <p class="text-xs font-bold text-purple-700 uppercase mb-2">Assignment Status</p>
                            <p class="text-purple-900 font-semibold">
                                <i class="fas fa-check-circle mr-2"></i>
                                Active
                            </p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Staff/Badge Information -->
            <?php if ($staff): ?>
                <div class="bg-white rounded-xl shadow-lg border border-gray-200 overflow-hidden">
                    <div class="bg-gradient-to-r from-indigo-50 to-indigo-100 border-b border-gray-200 px-6 py-4">
                        <h2 class="text-2xl font-bold text-gray-900">
                            <i class="fas fa-id-badge text-indigo-600 mr-3"></i>Staff Badge Information
                        </h2>
                    </div>
                    
                    <div class="p-8 space-y-5">
                        <div class="grid grid-cols-2 gap-6">
                            <!-- Badge Number -->
                            <div>
                                <label class="text-xs font-bold text-gray-600 uppercase tracking-wide block mb-2">Badge Number</label>
                                <p class="text-2xl font-bold text-indigo-600 font-mono"><?php echo htmlspecialchars($staff['badge_number'] ?? 'N/A'); ?></p>
                            </div>

                            <!-- Department -->
                            <div>
                                <label class="text-xs font-bold text-gray-600 uppercase tracking-wide block mb-2">Department</label>
                                <p class="text-gray-800 font-semibold"><?php echo htmlspecialchars($staff['department'] ?? 'Security'); ?></p>
                            </div>

                            <!-- Hire Date -->
                            <div>
                                <label class="text-xs font-bold text-gray-600 uppercase tracking-wide block mb-2">Hire Date</label>
                                <p class="text-gray-800 font-semibold"><?php echo $staff['hire_date'] ? date('M d, Y', strtotime($staff['hire_date'])) : 'N/A'; ?></p>
                            </div>

                            <!-- Employment Type -->
                            <div>
                                <label class="text-xs font-bold text-gray-600 uppercase tracking-wide block mb-2">Employment Type</label>
                                <p class="text-gray-800 font-semibold"><?php echo htmlspecialchars($staff['employment_type'] ?? 'Full-time'); ?></p>
                            </div>
                        </div>

                        <!-- Emergency Contact -->
                        <?php if (!empty($staff['emergency_contact'])): ?>
                            <div class="border-t border-gray-200 pt-6">
                                <label class="text-xs font-bold text-gray-600 uppercase tracking-wide block mb-2">Emergency Contact</label>
                                <p class="text-gray-800 font-semibold"><?php echo htmlspecialchars($staff['emergency_contact']); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Right Column - Actions -->
        <div class="lg:col-span-1">
            <!-- Quick Actions -->
            <div class="bg-white rounded-xl shadow-lg border border-gray-200 overflow-hidden sticky top-20">
                <div class="bg-gradient-to-r from-blue-50 to-blue-100 border-b border-gray-200 px-6 py-4">
                    <h3 class="text-xl font-bold text-gray-900">
                        <i class="fas fa-lightning-bolt text-blue-600 mr-2"></i>Quick Actions
                    </h3>
                </div>

                <div class="p-6 space-y-3">
                    <!-- Download Contract -->
                    <button onclick="downloadContract()" class="w-full px-4 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition font-bold flex items-center justify-center gap-2">
                        <i class="fas fa-download"></i>
                        <span>Download Contract</span>
                    </button>

                    <!-- View Posts -->
                    <a href="?page=controllers-posts" class="w-full px-4 py-3 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition font-bold flex items-center justify-center gap-2">
                        <i class="fas fa-map-pin"></i>
                        <span>View Posts</span>
                    </a>

                    <!-- View Patrols -->
                    <a href="?page=controllers-patrols" class="w-full px-4 py-3 bg-green-600 text-white rounded-lg hover:bg-green-700 transition font-bold flex items-center justify-center gap-2">
                        <i class="fas fa-shoe-prints"></i>
                        <span>View Patrols</span>
                    </a>

                    <!-- View Controls -->
                    <a href="?page=controllers-controls" class="w-full px-4 py-3 bg-orange-600 text-white rounded-lg hover:bg-orange-700 transition font-bold flex items-center justify-center gap-2">
                        <i class="fas fa-clipboard-check"></i>
                        <span>View Controls</span>
                    </a>

                    <!-- View Payments -->
                    <a href="?page=controllers-payments" class="w-full px-4 py-3 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700 transition font-bold flex items-center justify-center gap-2">
                        <i class="fas fa-money-bill"></i>
                        <span>View Payments</span>
                    </a>

                    <!-- Send Message -->
                    <a href="?page=controllers-messages" class="w-full px-4 py-3 bg-cyan-600 text-white rounded-lg hover:bg-cyan-700 transition font-bold flex items-center justify-center gap-2">
                        <i class="fas fa-envelope"></i>
                        <span>Send Message</span>
                    </a>
                </div>
            </div>

            <!-- Help Card -->
            <div class="mt-8 bg-gradient-to-br from-blue-50 to-blue-100 rounded-xl border-2 border-blue-200 p-6">
                <p class="text-sm font-semibold text-blue-900 mb-4">
                    <i class="fas fa-question-circle mr-2"></i>Need Help?
                </p>
                <p class="text-xs text-blue-800 leading-relaxed">
                    Contact the administration office for profile updates or contract inquiries.
                </p>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
function downloadContract() {
    const userId = <?php echo $_SESSION['user_id']; ?>;
    
    Swal.fire({
        title: 'Contract Download',
        text: 'Your contract will be prepared and downloaded. Please allow a few moments.',
        icon: 'info',
        confirmButtonText: 'OK',
        confirmButtonColor: '#2563eb'
    }).then(() => {
        const link = document.createElement('a');
        link.href = `?page=api&endpoint=controllers/download-contract&user_id=${userId}`;
        link.download = 'contract.pdf';
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    });
}
</script>

<?php require_once __DIR__ . '/../../layouts/footer.php'; ?>
