<?php
/**
 * Guards - My Post
 * View assigned post details
 */

$auth = $GLOBALS['auth'];
$db = $GLOBALS['db'];

$user = $auth->getCurrentUser();

if ($user['role'] !== 'guard') {
    header('Location: ?page=dashboard');
    exit();
}

// Get assigned post with all details
$post = $db->fetch(
    "SELECT gpa.*, p.* FROM guard_post_assignments gpa
     JOIN posts p ON gpa.post_id = p.id
     WHERE gpa.guard_id = ? AND gpa.status = 'Active'
     ORDER BY gpa.created_at DESC LIMIT 1",
    [$user['id']]
);

if (!$post) {
    echo "No assigned post found.";
    exit();
}

require_once __DIR__ . '/../../layouts/header.php';
?>

<div class="animate__animated animate__fadeIn">
    <!-- Page Header -->
    <div class="mb-8">
        <h1 class="text-4xl font-bold text-gray-800 mb-2">
            <i class="fas fa-map-pin text-green-600 mr-3"></i>My Assigned Post
        </h1>
        <p class="text-gray-600">Detailed information about your current assignment</p>
    </div>

    <!-- Post Details -->
    <div class="bg-white rounded-lg shadow p-8 mb-8">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Main Information -->
            <div class="lg:col-span-2">
                <h2 class="text-3xl font-bold text-gray-800 mb-6"><?php echo htmlspecialchars($post['name']); ?></h2>
                
                <div class="space-y-6">
                    <!-- Location -->
                    <div class="border-b pb-4">
                        <h3 class="text-lg font-bold text-gray-800 mb-3">
                            <i class="fas fa-location-dot text-red-600 mr-2"></i>Location
                        </h3>
                        <p class="text-gray-600"><?php echo htmlspecialchars($post['location'] ?? 'Not specified'); ?></p>
                    </div>

                    <!-- Facility Type -->
                    <div class="border-b pb-4">
                        <h3 class="text-lg font-bold text-gray-800 mb-3">
                            <i class="fas fa-building text-blue-600 mr-2"></i>Facility Type
                        </h3>
                        <p class="text-gray-600"><?php echo htmlspecialchars($post['facility_type'] ?? 'Not specified'); ?></p>
                    </div>

                    <!-- Contact Information -->
                    <div class="border-b pb-4">
                        <h3 class="text-lg font-bold text-gray-800 mb-3">
                            <i class="fas fa-phone text-green-600 mr-2"></i>Owner Contact
                        </h3>
                        <div class="space-y-2">
                            <p class="text-gray-600"><strong>Phone:</strong> <?php echo htmlspecialchars($post['owner_phone'] ?? 'Not provided'); ?></p>
                            <p class="text-gray-600"><strong>Address:</strong> <?php echo htmlspecialchars($post['owner_address'] ?? 'Not provided'); ?></p>
                        </div>
                    </div>

                    <!-- Assessment Summary -->
                    <div class="border-b pb-4">
                        <h3 class="text-lg font-bold text-gray-800 mb-3">
                            <i class="fas fa-chart-bar text-yellow-600 mr-2"></i>Assessment Summary
                        </h3>
                        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                            <div class="bg-gray-50 p-4 rounded">
                                <p class="text-xs text-gray-600 font-semibold uppercase">Security Post</p>
                                <p class="text-lg font-bold text-gray-800"><?php echo htmlspecialchars($post['assessment_security_post'] ?? 'Fair'); ?></p>
                            </div>
                            <div class="bg-gray-50 p-4 rounded">
                                <p class="text-xs text-gray-600 font-semibold uppercase">Fence</p>
                                <p class="text-lg font-bold text-gray-800"><?php echo htmlspecialchars($post['assessment_fence'] ?? 'Fair'); ?></p>
                            </div>
                            <div class="bg-gray-50 p-4 rounded">
                                <p class="text-xs text-gray-600 font-semibold uppercase">CCTV/Alarms</p>
                                <p class="text-lg font-bold text-gray-800"><?php echo htmlspecialchars($post['assessment_cctv_alarms'] ?? 'Fair'); ?></p>
                            </div>
                            <div class="bg-gray-50 p-4 rounded">
                                <p class="text-xs text-gray-600 font-semibold uppercase">Fire Ext.</p>
                                <p class="text-lg font-bold text-gray-800"><?php echo htmlspecialchars($post['assessment_fire_extinguishers'] ?? 'Fair'); ?></p>
                            </div>
                            <div class="bg-gray-50 p-4 rounded">
                                <p class="text-xs text-gray-600 font-semibold uppercase">Lighting</p>
                                <p class="text-lg font-bold text-gray-800"><?php echo htmlspecialchars($post['assessment_lighting'] ?? 'Fair'); ?></p>
                            </div>
                            <div class="bg-gray-50 p-4 rounded">
                                <p class="text-xs text-gray-600 font-semibold uppercase">Crime Rate</p>
                                <p class="text-lg font-bold text-gray-800"><?php echo htmlspecialchars($post['assessment_crime_rate'] ?? 'Medium'); ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Observations -->
                    <?php if (!empty($post['observations'])): ?>
                    <div class="border-b pb-4">
                        <h3 class="text-lg font-bold text-gray-800 mb-3">
                            <i class="fas fa-comment text-blue-600 mr-2"></i>Observations
                        </h3>
                        <p class="text-gray-600"><?php echo nl2br(htmlspecialchars($post['observations'])); ?></p>
                    </div>
                    <?php endif; ?>

                    <!-- Recommendations -->
                    <?php if (!empty($post['recommendations'])): ?>
                    <div>
                        <h3 class="text-lg font-bold text-gray-800 mb-3">
                            <i class="fas fa-lightbulb text-yellow-600 mr-2"></i>Recommendations
                        </h3>
                        <p class="text-gray-600"><?php echo nl2br(htmlspecialchars($post['recommendations'])); ?></p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Sidebar Information -->
            <div>
                <div class="bg-gradient-to-br from-green-50 to-green-100 rounded-lg p-6 border border-green-200 mb-6">
                    <h3 class="text-lg font-bold text-green-900 mb-4">Assignment Details</h3>
                    <div class="space-y-4">
                        <div>
                            <p class="text-xs text-green-700 font-semibold uppercase">Status</p>
                            <p class="text-2xl font-bold text-green-600">Active</p>
                        </div>
                        <div>
                            <p class="text-xs text-green-700 font-semibold uppercase">Assigned Since</p>
                            <p class="text-gray-800"><?php echo date('M d, Y', strtotime($post['created_at'])); ?></p>
                        </div>
                        <div>
                            <p class="text-xs text-green-700 font-semibold uppercase">Surface Area</p>
                            <p class="text-gray-800"><?php echo htmlspecialchars($post['surface_area'] ?? 'Not specified'); ?> <?php echo htmlspecialchars($post['surface_area'] ? 'm²' : ''); ?></p>
                        </div>
                    </div>
                </div>

                <div class="bg-blue-50 rounded-lg p-6 border border-blue-200">
                    <h3 class="text-lg font-bold text-blue-900 mb-4">Quick Actions</h3>
                    <div class="space-y-3">
                        <a href="?page=guards/patrols" class="block w-full bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition text-center font-semibold text-sm">
                            <i class="fas fa-walking mr-2"></i>View Patrols
                        </a>
                        <a href="?page=guards/messages" class="block w-full bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition text-center font-semibold text-sm">
                            <i class="fas fa-envelope mr-2"></i>Send Message
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<?php require_once __DIR__ . '/../../layouts/footer.php'; ?>
