<?php
/**
 * Landing Page - Bilingual (EN/FR)
 * Modern, Clean Design with Hero Slider and Features
 */

// Determine language
$lang = $_GET['lang'] ?? ($_SESSION['language'] ?? 'en');
if (!in_array($lang, ['en', 'fr'])) $lang = 'en';

// Translations
$translations = [
    'en' => [
        'title' => 'Shepherd Security Platform',
        'tagline' => 'Professional Security Management Solution',
        'hero_title' => 'Comprehensive Security Management Platform',
        'hero_subtitle' => 'Streamline your security operations with advanced scheduling, real-time tracking, and comprehensive reporting.',
        'features' => 'Features',
        'quick_links' => 'Quick Links',
        'enter_portal' => 'Enter Portal',
        'visit_website' => 'Visit Website',
        'feature_1' => 'Real-Time Monitoring',
        'feature_1_desc' => 'Track security operations with live GPS integration and real-time status updates',
        'feature_2' => 'Staff Management',
        'feature_2_desc' => 'Efficiently manage guards, controllers, and administrators with role-based access control',
        'feature_3' => 'Invoice & Billing',
        'feature_3_desc' => 'Generate professional invoices with automatic billing and payment tracking',
        'feature_4' => 'Client Portal',
        'feature_4_desc' => 'Clients access invoices, payments, contracts, and submit feedback 24/7',
        'feature_5' => 'Assessment Tools',
        'feature_5_desc' => 'Comprehensive staff evaluation system with detailed scoring and feedback',
        'feature_6' => 'Mobile App',
        'feature_6_desc' => 'Full offline functionality with automatic sync when connectivity is restored',
        'login' => 'Login',
        'all_rights' => 'All Rights Reserved'
    ],
    'fr' => [
        'title' => 'Plateforme Shepherd Security',
        'tagline' => 'Solution professionnelle de gestion de la sécurité',
        'hero_title' => 'Plateforme complète de gestion de la sécurité',
        'hero_subtitle' => 'Rationalisez vos opérations de sécurité avec la planification avancée, le suivi en temps réel et les rapports détaillés.',
        'features' => 'Caractéristiques',
        'quick_links' => 'Liens rapides',
        'enter_portal' => 'Entrer le portail',
        'visit_website' => 'Visiter le site',
        'feature_1' => 'Surveillance en temps réel',
        'feature_1_desc' => 'Suivez les opérations de sécurité avec intégration GPS en direct et mises à jour de statut en temps réel',
        'feature_2' => 'Gestion du personnel',
        'feature_2_desc' => 'Gérez efficacement les gardes, contrôleurs et administrateurs avec contrôle d\'accès basé sur les rôles',
        'feature_3' => 'Facturation et factures',
        'feature_3_desc' => 'Générez des factures professionnelles avec facturation automatique et suivi des paiements',
        'feature_4' => 'Portail client',
        'feature_4_desc' => 'Les clients accèdent aux factures, paiements, contrats et envoient des commentaires 24h/24',
        'feature_5' => 'Outils d\'évaluation',
        'feature_5_desc' => 'Système d\'évaluation du personnel complet avec notation détaillée et retours',
        'feature_6' => 'Application mobile',
        'feature_6_desc' => 'Fonctionnalité hors ligne complète avec synchronisation automatique lors du rétablissement de la connectivité',
        'login' => 'Se connecter',
        'all_rights' => 'Tous droits réservés'
    ]
];

$t = $translations[$lang];
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $t['title']; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @keyframes kenburn {
            0% { transform: scale(1.1) translateY(-5%); }
            100% { transform: scale(1) translateY(0); }
        }
        
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes slideIn {
            from {
                opacity: 0;
                transform: translateX(-20px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        
        .kenburn {
            animation: kenburn 15s ease-out infinite;
            transform-origin: center;
        }
        
        .fade-in-up {
            animation: fadeInUp 0.8s ease-out forwards;
        }
        
        .slide-in {
            animation: slideIn 0.8s ease-out forwards;
        }
        
        .hero-slide {
            position: absolute;
            width: 100%;
            height: 100%;
            opacity: 0;
            transition: opacity 1s ease-in-out;
        }
        
        .hero-slide.active {
            opacity: 1;
        }
        
        .feature-card {
            transition: all 0.3s ease;
        }
        
        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
        }
        
        .lang-btn {
            transition: all 0.3s ease;
        }
        
        .lang-btn.active {
            background-color: #3b82f6;
            color: white;
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Navigation -->
    <nav class="bg-white shadow-sm sticky top-0 z-40">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4 flex justify-between items-center">
            <div class="flex items-center gap-2">
                <i class="fas fa-shield text-blue-600 text-2xl"></i>
                <span class="font-bold text-xl text-gray-800"><?php echo $t['title']; ?></span>
            </div>
            
            <div class="flex items-center gap-4">
                <!-- Language Switcher -->
                <div class="flex gap-2">
                    <a href="?lang=en" class="lang-btn px-3 py-1 rounded text-sm font-medium <?php echo $lang === 'en' ? 'active' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'; ?>">
                        EN
                    </a>
                    <a href="?lang=fr" class="lang-btn px-3 py-1 rounded text-sm font-medium <?php echo $lang === 'fr' ? 'active' : 'bg-gray-100 text-gray-700 hover:bg-gray-200'; ?>">
                        FR
                    </a>
                </div>
                
                <!-- Login Button -->
                <a href="<?php echo $auth->isAuthenticated() ? '?page=dashboard' : '?page=login'; ?>" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition font-medium">
                    <?php echo $auth->isAuthenticated() ? 'Dashboard' : $t['login']; ?>
                </a>
            </div>
        </div>
    </nav>

    <!-- Hero Section with Slider -->
    <section class="relative h-screen overflow-hidden bg-black">
        <!-- Slide 1 -->
        <div class="hero-slide active">
            <div class="relative h-full w-full">
                <div class="absolute inset-0 bg-gradient-to-r from-black/60 to-black/30"></div>
                <div class="absolute inset-0 kenburn" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);"></div>
                
                <div class="relative h-full flex items-center justify-center z-10">
                    <div class="text-center text-white px-4 max-w-2xl fade-in-up">
                        <h1 class="text-5xl md:text-6xl font-bold mb-4"><?php echo $t['hero_title']; ?></h1>
                        <p class="text-xl md:text-2xl text-gray-200 mb-8"><?php echo $t['hero_subtitle']; ?></p>
                        <div class="flex gap-4 justify-center flex-wrap">
                            <a href="<?php echo $auth->isAuthenticated() ? '?page=dashboard' : '?page=login'; ?>" class="px-8 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition font-semibold flex items-center gap-2">
                                <i class="fas fa-arrow-right"></i><?php echo $t['enter_portal']; ?>
                            </a>
                            <a href="https://www.shepherd-security.online" target="_blank" class="px-8 py-3 bg-white text-blue-600 rounded-lg hover:bg-gray-100 transition font-semibold flex items-center gap-2">
                                <i class="fas fa-globe"></i><?php echo $t['visit_website']; ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Slide 2 -->
        <div class="hero-slide">
            <div class="relative h-full w-full">
                <div class="absolute inset-0 bg-gradient-to-r from-black/60 to-black/30"></div>
                <div class="absolute inset-0 kenburn" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);"></div>
                
                <div class="relative h-full flex items-center justify-center z-10">
                    <div class="text-center text-white px-4 max-w-2xl fade-in-up">
                        <div class="mb-6 text-6xl"><i class="fas fa-chart-line"></i></div>
                        <h2 class="text-4xl font-bold mb-3"><?php echo $t['feature_3']; ?></h2>
                        <p class="text-lg text-gray-200"><?php echo $t['feature_3_desc']; ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Slide 3 -->
        <div class="hero-slide">
            <div class="relative h-full w-full">
                <div class="absolute inset-0 bg-gradient-to-r from-black/60 to-black/30"></div>
                <div class="absolute inset-0 kenburn" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);"></div>
                
                <div class="relative h-full flex items-center justify-center z-10">
                    <div class="text-center text-white px-4 max-w-2xl fade-in-up">
                        <div class="mb-6 text-6xl"><i class="fas fa-mobile-alt"></i></div>
                        <h2 class="text-4xl font-bold mb-3"><?php echo $t['feature_6']; ?></h2>
                        <p class="text-lg text-gray-200"><?php echo $t['feature_6_desc']; ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Slider Controls -->
        <div class="absolute bottom-8 left-1/2 transform -translate-x-1/2 z-20 flex gap-2">
            <button onclick="prevSlide()" class="px-4 py-2 bg-white text-gray-800 rounded hover:bg-gray-100 transition">
                <i class="fas fa-chevron-left"></i>
            </button>
            <div class="flex gap-2">
                <button onclick="goToSlide(0)" class="slide-dot w-3 h-3 bg-white rounded-full opacity-50 hover:opacity-100 transition active" data-slide="0"></button>
                <button onclick="goToSlide(1)" class="slide-dot w-3 h-3 bg-white rounded-full opacity-50 hover:opacity-100 transition" data-slide="1"></button>
                <button onclick="goToSlide(2)" class="slide-dot w-3 h-3 bg-white rounded-full opacity-50 hover:opacity-100 transition" data-slide="2"></button>
            </div>
            <button onclick="nextSlide()" class="px-4 py-2 bg-white text-gray-800 rounded hover:bg-gray-100 transition">
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-20 px-4 max-w-7xl mx-auto">
        <div class="text-center mb-16">
            <h2 class="text-4xl font-bold text-gray-900 mb-4"><?php echo $t['features']; ?></h2>
            <div class="w-20 h-1 bg-blue-600 mx-auto"></div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Feature 1 -->
            <div class="feature-card bg-white rounded-lg shadow-sm p-8 border-t-4 border-blue-600">
                <div class="text-4xl text-blue-600 mb-4"><i class="fas fa-radar"></i></div>
                <h3 class="text-xl font-bold text-gray-900 mb-2"><?php echo $t['feature_1']; ?></h3>
                <p class="text-gray-600"><?php echo $t['feature_1_desc']; ?></p>
            </div>

            <!-- Feature 2 -->
            <div class="feature-card bg-white rounded-lg shadow-sm p-8 border-t-4 border-green-600">
                <div class="text-4xl text-green-600 mb-4"><i class="fas fa-users"></i></div>
                <h3 class="text-xl font-bold text-gray-900 mb-2"><?php echo $t['feature_2']; ?></h3>
                <p class="text-gray-600"><?php echo $t['feature_2_desc']; ?></p>
            </div>

            <!-- Feature 3 -->
            <div class="feature-card bg-white rounded-lg shadow-sm p-8 border-t-4 border-purple-600">
                <div class="text-4xl text-purple-600 mb-4"><i class="fas fa-file-invoice-dollar"></i></div>
                <h3 class="text-xl font-bold text-gray-900 mb-2"><?php echo $t['feature_3']; ?></h3>
                <p class="text-gray-600"><?php echo $t['feature_3_desc']; ?></p>
            </div>

            <!-- Feature 4 -->
            <div class="feature-card bg-white rounded-lg shadow-sm p-8 border-t-4 border-pink-600">
                <div class="text-4xl text-pink-600 mb-4"><i class="fas fa-user-circle"></i></div>
                <h3 class="text-xl font-bold text-gray-900 mb-2"><?php echo $t['feature_4']; ?></h3>
                <p class="text-gray-600"><?php echo $t['feature_4_desc']; ?></p>
            </div>

            <!-- Feature 5 -->
            <div class="feature-card bg-white rounded-lg shadow-sm p-8 border-t-4 border-yellow-600">
                <div class="text-4xl text-yellow-600 mb-4"><i class="fas fa-star"></i></div>
                <h3 class="text-xl font-bold text-gray-900 mb-2"><?php echo $t['feature_5']; ?></h3>
                <p class="text-gray-600"><?php echo $t['feature_5_desc']; ?></p>
            </div>

            <!-- Feature 6 -->
            <div class="feature-card bg-white rounded-lg shadow-sm p-8 border-t-4 border-indigo-600">
                <div class="text-4xl text-indigo-600 mb-4"><i class="fas fa-mobile-alt"></i></div>
                <h3 class="text-xl font-bold text-gray-900 mb-2"><?php echo $t['feature_6']; ?></h3>
                <p class="text-gray-600"><?php echo $t['feature_6_desc']; ?></p>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="bg-gradient-to-r from-blue-600 to-blue-800 py-16 px-4">
        <div class="max-w-7xl mx-auto text-center text-white">
            <h2 class="text-3xl font-bold mb-4"><?php echo $t['tagline']; ?></h2>
            <p class="text-lg opacity-90 mb-8 max-w-2xl mx-auto"><?php echo $t['hero_subtitle']; ?></p>
            <div class="flex gap-4 justify-center flex-wrap">
                <a href="<?php echo $auth->isAuthenticated() ? '?page=dashboard' : '?page=login'; ?>" class="px-8 py-3 bg-white text-blue-600 rounded-lg hover:bg-gray-100 transition font-semibold">
                    <?php echo $auth->isAuthenticated() ? 'Dashboard' : $t['enter_portal']; ?>
                </a>
                <a href="https://www.shepherd-security.online" target="_blank" class="px-8 py-3 border-2 border-white text-white rounded-lg hover:bg-white hover:text-blue-600 transition font-semibold">
                    <?php echo $t['visit_website']; ?>
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-900 text-gray-400 py-8 px-4">
        <div class="max-w-7xl mx-auto text-center">
            <p>&copy; 2025 Shepherd Security. <?php echo $t['all_rights']; ?></p>
        </div>
    </footer>

    <script>
        let currentSlide = 0;
        const slides = document.querySelectorAll('.hero-slide');
        const dots = document.querySelectorAll('.slide-dot');
        
        function showSlide(n) {
            slides.forEach(slide => slide.classList.remove('active'));
            dots.forEach(dot => dot.classList.remove('active'));
            
            slides[n].classList.add('active');
            dots[n].classList.add('active');
        }
        
        function nextSlide() {
            currentSlide = (currentSlide + 1) % slides.length;
            showSlide(currentSlide);
        }
        
        function prevSlide() {
            currentSlide = (currentSlide - 1 + slides.length) % slides.length;
            showSlide(currentSlide);
        }
        
        function goToSlide(n) {
            currentSlide = n;
            showSlide(currentSlide);
        }
        
        // Auto-advance slides every 10 seconds
        setInterval(nextSlide, 10000);
    </script>
</body>
</html>
